/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.parser;

import android.os.Build;
import at.favre.lib.planb.data.CrashData;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BugReportPlaceholderHandler {
    private static final String PH_TIMESTAMP = "timestamp";
    private static final String PH_VERSION = "version";
    private static final String PH_SCM = "scm";
    private static final String PH_CI = "ci";
    private static final String PH_DEVICE = "device";
    private static final String PH_ANDROID_VERSION = "android_version";
    private static final String PH_DEVICE_SERIAL = "device_serial";
    private static final String PH_EXCEPTION_SUMMARY = "exception";
    private static final String PH_STACKTRACE = "stacktrace";
    private final Map<String, String> map = new HashMap<String, String>();

    public BugReportPlaceholderHandler(CrashData crashData) {
        this.map.put(PH_TIMESTAMP, new Date(crashData.timestamp).toString());
        this.map.put(PH_VERSION, crashData.versionString);
        this.map.put(PH_SCM, crashData.scmString);
        this.map.put(PH_CI, crashData.ciString);
        this.map.put(PH_VERSION, crashData.versionString);
        this.map.put(PH_DEVICE, Build.MANUFACTURER + " " + Build.MODEL + " (" + Build.DEVICE + ")");
        this.map.put(PH_ANDROID_VERSION, Build.VERSION.RELEASE + " (" + String.valueOf(Build.VERSION.SDK_INT) + ")");
        this.map.put(PH_DEVICE_SERIAL, Build.SERIAL);
        this.map.put(PH_EXCEPTION_SUMMARY, crashData.causeClassName + ": " + crashData.message);
        this.map.put(PH_STACKTRACE, crashData.fullStacktrace);
    }

    public Map<String, String> getPlaceHolderMap() {
        return this.map;
    }
}

