/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.data;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import at.favre.lib.planb.data.CrashData;
import at.favre.lib.planb.interfaces.CrashDataHandler;
import at.favre.lib.planb.util.CrashDataUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SharedPrefCrashDataHandler
implements CrashDataHandler {
    private static final String PREF_PREFIX = "at.favre.lib.planb.1870382740324_";
    private static final String KEY_LATEST = "KEY_LATEST";
    private static final String KEY_HASNEW = "KEY_HASNEW";
    private static final int DEFAULT_CRASH_DATA_SIZE = 50;
    private static final int MAX_CRASH_DATA_SIZE = 200;
    private SharedPreferences preferences;
    private int capacity;

    public SharedPrefCrashDataHandler(Context context) {
        this(context, 50);
    }

    public SharedPrefCrashDataHandler(Context context, int maxCapacity) {
        if (maxCapacity > 200 || maxCapacity < 1) {
            throw new IllegalArgumentException("Cannot create with this capacity. Max capacity is 200 but " + maxCapacity + " was provided.");
        }
        this.preferences = context.getSharedPreferences(PREF_PREFIX, 0);
        this.capacity = maxCapacity;
    }

    @Override
    public CrashData getLatest() {
        CrashData cd = CrashDataUtil.createCrashDataFromStringSet(this.preferences.getStringSet(this.preferences.getString(KEY_LATEST, null), null));
        this.preferences.edit().putBoolean(KEY_HASNEW, false).apply();
        return cd;
    }

    @Override
    @NonNull
    public List<CrashData> getAll() {
        ArrayList<CrashData> crashDataList = new ArrayList<CrashData>();
        for (Map.Entry entry : this.preferences.getAll().entrySet()) {
            if (!(entry.getValue() instanceof Set)) continue;
            crashDataList.add(CrashDataUtil.createCrashDataFromStringSet((Set)entry.getValue()));
        }
        return crashDataList;
    }

    @Override
    public int size() {
        return this.getAll().size();
    }

    @Override
    public boolean hasUnhandledCrash() {
        return this.preferences.getBoolean(KEY_HASNEW, false);
    }

    @Override
    @SuppressLint(value={"ApplySharedPref"})
    public void persistCrashData(CrashData cd) {
        this.preferences.edit().putStringSet(cd.id, CrashDataUtil.createCrashDataSet(cd)).putString(KEY_LATEST, cd.id).putBoolean(KEY_HASNEW, true).commit();
        List<CrashData> all = this.getAll();
        if (all.size() > this.capacity) {
            Collections.sort(all);
            List<CrashData> overflowList = all.subList(this.capacity, all.size());
            SharedPreferences.Editor editor = this.preferences.edit();
            for (CrashData crashData : overflowList) {
                editor.remove(crashData.id);
            }
            editor.commit();
        }
    }

    @Override
    public int countOfCrashesSince(long fromTimestamp) {
        List<CrashData> crashDatas = this.getAll();
        int count = 0;
        for (CrashData crashData : crashDatas) {
            if (crashData.timestamp < fromTimestamp) continue;
            ++count;
        }
        return count;
    }

    @Override
    @SuppressLint(value={"ApplySharedPref"})
    public void clear() {
        this.preferences.edit().clear().commit();
    }
}

