/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.data;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import at.favre.lib.planb.data.CrashData;
import at.favre.lib.planb.interfaces.CrashDataHandler;
import java.util.ArrayList;
import java.util.List;

public class InMemoryCrashDataHandler
implements CrashDataHandler {
    private List<CrashData> crashDataList = new ArrayList<CrashData>();
    private boolean unhandled = false;

    @Override
    @Nullable
    public CrashData getLatest() {
        this.unhandled = false;
        if (this.crashDataList.isEmpty()) {
            return null;
        }
        return this.crashDataList.get(0);
    }

    @Override
    @NonNull
    public List<CrashData> getAll() {
        return this.crashDataList;
    }

    @Override
    public int size() {
        return this.crashDataList.size();
    }

    @Override
    public boolean hasUnhandledCrash() {
        return this.unhandled;
    }

    @Override
    public void persistCrashData(@NonNull CrashData crashData) {
        this.unhandled = true;
        this.crashDataList.add(crashData);
    }

    @Override
    public int countOfCrashesSince(long fromTimestamp) {
        int count = 0;
        for (CrashData crashData : this.getAll()) {
            if (crashData.timestamp < fromTimestamp) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void clear() {
        this.crashDataList.clear();
    }
}

