/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import at.favre.lib.planb.data.SharedPrefCrashDataHandler;
import at.favre.lib.planb.interfaces.CrashDataHandler;

public class PlanBConfig {
    public final boolean enableLog;
    public final int bugReportMarkupLanguage;
    public final String versionName;
    public final int versionCode;
    public final String appBuiltType;
    public final String appFlavour;
    public final String scmRevHash;
    public final String scmBranch;
    public final String ciBuildId;
    public final String ciBuildJob;
    public final CrashDataHandler debugCrashDataHandler;
    public final CrashDataHandler releaseCrashDataHandler;

    private PlanBConfig(Builder builder) {
        this.enableLog = builder.enableLog;
        this.bugReportMarkupLanguage = builder.bugReportMarkupLanguage;
        this.versionName = builder.versionName;
        this.versionCode = builder.versionCode;
        this.appBuiltType = builder.appBuiltType;
        this.appFlavour = builder.appFlavour;
        this.scmRevHash = builder.scmRevHash;
        this.scmBranch = builder.scmBranch;
        this.ciBuildId = builder.ciBuildId;
        this.ciBuildJob = builder.ciBuildJob;
        this.debugCrashDataHandler = builder.debugCrashDataHandler;
        this.releaseCrashDataHandler = builder.releaseCrashDataHandler;
    }

    static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    @VisibleForTesting(otherwise=5)
    static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanBConfig that = (PlanBConfig)o;
        if (this.enableLog != that.enableLog) {
            return false;
        }
        if (this.bugReportMarkupLanguage != that.bugReportMarkupLanguage) {
            return false;
        }
        if (this.versionCode != that.versionCode) {
            return false;
        }
        if (this.versionName != null ? !this.versionName.equals(that.versionName) : that.versionName != null) {
            return false;
        }
        if (this.appBuiltType != null ? !this.appBuiltType.equals(that.appBuiltType) : that.appBuiltType != null) {
            return false;
        }
        if (this.appFlavour != null ? !this.appFlavour.equals(that.appFlavour) : that.appFlavour != null) {
            return false;
        }
        if (this.scmRevHash != null ? !this.scmRevHash.equals(that.scmRevHash) : that.scmRevHash != null) {
            return false;
        }
        if (this.scmBranch != null ? !this.scmBranch.equals(that.scmBranch) : that.scmBranch != null) {
            return false;
        }
        if (this.ciBuildId != null ? !this.ciBuildId.equals(that.ciBuildId) : that.ciBuildId != null) {
            return false;
        }
        return this.ciBuildJob != null ? this.ciBuildJob.equals(that.ciBuildJob) : that.ciBuildJob == null;
    }

    public int hashCode() {
        int result = this.enableLog ? 1 : 0;
        result = 31 * result + this.bugReportMarkupLanguage;
        result = 31 * result + (this.versionName != null ? this.versionName.hashCode() : 0);
        result = 31 * result + this.versionCode;
        result = 31 * result + (this.appBuiltType != null ? this.appBuiltType.hashCode() : 0);
        result = 31 * result + (this.appFlavour != null ? this.appFlavour.hashCode() : 0);
        result = 31 * result + (this.scmRevHash != null ? this.scmRevHash.hashCode() : 0);
        result = 31 * result + (this.scmBranch != null ? this.scmBranch.hashCode() : 0);
        result = 31 * result + (this.ciBuildId != null ? this.ciBuildId.hashCode() : 0);
        result = 31 * result + (this.ciBuildJob != null ? this.ciBuildJob.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private boolean enableLog;
        private int bugReportMarkupLanguage;
        private String versionName;
        private int versionCode;
        private String appBuiltType;
        private String appFlavour;
        private String scmRevHash;
        private String scmBranch;
        private String ciBuildId;
        private String ciBuildJob;
        private CrashDataHandler debugCrashDataHandler;
        private CrashDataHandler releaseCrashDataHandler;

        private Builder(Context context) {
            this.debugCrashDataHandler = this.releaseCrashDataHandler = new SharedPrefCrashDataHandler(context);
            this.bugReportMarkupLanguage = 0;
            try {
                this.versionName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
                this.versionCode = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @VisibleForTesting(otherwise=5)
        public Builder() {
        }

        public Builder enableLog(boolean enableLog) {
            this.enableLog = enableLog;
            return this;
        }

        public Builder bugReportMarkupLanguage(int bugReportMarkupLanguage) {
            this.bugReportMarkupLanguage = bugReportMarkupLanguage;
            return this;
        }

        public Builder version(String versionName, int versionCode) {
            this.versionName = versionName;
            this.versionCode = versionCode;
            return this;
        }

        public Builder applicationVariant(String appBuiltType, String appFlavour) {
            this.appBuiltType = appBuiltType;
            this.appFlavour = appFlavour;
            return this;
        }

        public Builder scm(String scmRevHash, @Nullable String scmBranch) {
            this.scmRevHash = scmRevHash;
            this.scmBranch = scmBranch;
            return this;
        }

        public Builder ci(String ciBuildId, @Nullable String ciBuildJob) {
            this.ciBuildId = ciBuildId;
            this.ciBuildJob = ciBuildJob;
            return this;
        }

        public Builder crashDataHandler(CrashDataHandler crashDataHandler) {
            this.debugCrashDataHandler = crashDataHandler;
            this.releaseCrashDataHandler = crashDataHandler;
            return this;
        }

        public Builder debugCrashDataHandler(CrashDataHandler crashDataHandler) {
            this.debugCrashDataHandler = crashDataHandler;
            return this;
        }

        public Builder releaseCrashDataHandler(CrashDataHandler crashDataHandler) {
            this.releaseCrashDataHandler = crashDataHandler;
            return this;
        }

        public PlanBConfig build() {
            return new PlanBConfig(this);
        }
    }
}

