/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.util;

import android.app.ActivityManager;
import android.content.Context;
import at.favre.lib.planb.exceptions.MockRuntimeException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class CrashUtil {
    public static void crash() {
        throw new MockRuntimeException();
    }

    public static boolean isAppInBackground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(context.getPackageName())) continue;
            return appProcess.importance == 400;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String printStacktrace(Throwable t) {
        StringWriter sw = null;
        try {
            sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
        finally {
            if (sw != null) {
                try {
                    sw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

