/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.util;

import at.favre.lib.planb.PlanBConfig;
import at.favre.lib.planb.data.CrashData;
import at.favre.lib.planb.util.CrashUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;

public class CrashDataUtil {
    private static final String DIVIDER = ":::o:::";
    private static final String DIVIDER_NULL = ":::o::null:";

    public static Set<String> createCrashDataSet(CrashData crashData) {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, String> entry : crashData.createMap().entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("key must not be null");
            }
            if (entry.getValue() == null) {
                set.add(entry.getKey() + DIVIDER_NULL);
                continue;
            }
            set.add(entry.getKey() + DIVIDER + entry.getValue());
        }
        return set;
    }

    public static CrashData createCrashDataFromStringSet(Set<String> serialized) {
        if (serialized == null) {
            return null;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (String s : serialized) {
            if (s.endsWith(DIVIDER_NULL)) {
                dataMap.put(s.split(DIVIDER_NULL)[0], null);
                continue;
            }
            String[] parts = s.split(DIVIDER);
            if (parts.length == 1) {
                dataMap.put(parts[0], "");
                continue;
            }
            dataMap.put(parts[0], parts[1]);
        }
        return CrashData.create(dataMap);
    }

    public static CrashData createFromCrash(PlanBConfig config, Thread thread, Throwable throwable, Map<String, String> customData) {
        if (throwable == null) {
            throw new IllegalArgumentException("throwable must not be null");
        }
        StackTraceElement element = throwable.getStackTrace()[0];
        return new CrashData(UUID.randomUUID().toString(), System.currentTimeMillis(), throwable.getMessage(), throwable.getClass().getName(), thread.getName() + " [" + thread.getId() + "]", element.getClassName(), element.getMethodName(), element.getFileName(), element.getLineNumber(), CrashUtil.printStacktrace(throwable), config.versionName + " (" + config.versionCode + ")", config.appBuiltType + (config.appFlavour != null && !config.appFlavour.isEmpty() ? ":" + config.appFlavour : ""), config.scmRevHash != null ? config.scmRevHash.substring(0, Math.min(8, config.scmRevHash.length())) + " (" + config.scmBranch + ")" : "", config.ciBuildId != null ? config.ciBuildId + (config.ciBuildJob != null ? " / " + config.ciBuildJob : "") : "", customData);
    }

    public static String getClassNameForException(String throwableClassName) {
        if (throwableClassName != null && throwableClassName.contains(".")) {
            String[] parts = throwableClassName.split(Pattern.quote("."));
            return parts[parts.length - 1];
        }
        return throwableClassName;
    }

    public static String parseDate(long timestamp) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z", Locale.getDefault()).format(new Date(timestamp));
    }

    public static StringBuilder getLogString(List<CrashData> crashDataList) {
        StringBuilder sb = new StringBuilder("==== STORED CRASH DATA (").append(crashDataList.size()).append(") ===\n");
        for (CrashData crashData : crashDataList) {
            sb.append(CrashDataUtil.parseDate(crashData.timestamp)).append("\n");
            sb.append(crashData.throwableClassName).append(": ").append(crashData.message).append("\n");
            sb.append("\tcaused by ").append(crashData.causeClassName).append(".").append(crashData.causeMethodName).append("(").append(crashData.causeFileName).append(":").append(crashData.causeLineNum).append(")");
            sb.append("\n------------------------\n");
        }
        sb.append("\n");
        return sb;
    }

    public static StringBuilder getLogString(CrashData crashData) {
        StringBuilder sb = new StringBuilder("==== RECORDED UNHANDLED EXCEPTION ==\n");
        sb.append(CrashDataUtil.parseDate(crashData.timestamp)).append("\n");
        sb.append(crashData.throwableClassName).append(": ").append(crashData.message).append("\n");
        sb.append("\tVersion: ").append(crashData.versionString).append(", SCM: ").append(crashData.scmString).append(", CI: ").append(crashData.ciString).append("\n\n");
        sb.append("\t").append(crashData.fullStacktrace);
        return sb;
    }
}

