/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.parser;

import android.support.annotation.NonNull;
import at.favre.lib.planb.parser.AsciiDocRenderer;
import at.favre.lib.planb.parser.HTML5Renderer;
import at.favre.lib.planb.parser.MarkdownRenderer;
import at.favre.lib.planb.parser.TextileRenderer;

public interface MarkupRenderer {
    public static final int ML_MARKDOWN = 0;
    public static final int ML_TEXTILE = 1;
    public static final int ML_ASCIIDOC = 2;
    public static final int ML_HTML = 3;

    @NonNull
    public String renderHeader();

    public String render(String var1, int var2);

    @NonNull
    public String renderFooter();

    public int getType();

    public static class Util {
        public static MarkupRenderer getById(int languageId) {
            switch (languageId) {
                case 0: {
                    return new MarkdownRenderer();
                }
                case 1: {
                    return new TextileRenderer();
                }
                case 2: {
                    return new AsciiDocRenderer();
                }
                case 3: {
                    return new HTML5Renderer();
                }
            }
            throw new IllegalArgumentException("unknown markup language " + languageId);
        }
    }
}

