/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb.data;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CrashData
implements Comparable<CrashData>,
Parcelable {
    private static final String MAP_SPLIT = ":";
    private static final String ARG_ID = "ARG_ID";
    private static final String ARG_DATE = "ARG_DATE";
    private static final String ARG_FULLSTACK = "ARG_FULLSTACK";
    private static final String ARG_MSG = "ARG_MSG";
    private static final String ARG_THROWABLE_CLASS_NAME = "ARG_THROWABLE_CLASS_NAME";
    private static final String ARG_THREAD_NAME = "ARG_THREAD_NAME";
    private static final String ARG_CAUSE_CLASS_NAME = "ARG_CAUSE_CLASS_NAME";
    private static final String ARG_CAUSE_METHOD_NAME = "ARG_CAUSE_METHOD_NAME";
    private static final String ARG_CAUSE_FILE_NAME = "ARG_CAUSE_FILE_NAME";
    private static final String ARG_CAUSE_LINE_NUM = "ARG_CAUSE_LINE_NUM";
    private static final String ARG_VERSION = "ARG_VERSION";
    private static final String ARG_SCM = "ARG_SCM";
    private static final String ARG_CI = "ARG_CI";
    private static final String ARG_APP_VARIANT = "ARG_APP_VARIANT";
    private static final String ARG_CUSTOM_MAP = "ARG_CUSTOM_MAP";
    public final String id;
    public final long timestamp;
    public final String message;
    public final String throwableClassName;
    public final String threadName;
    public final String causeClassName;
    public final String causeMethodName;
    public final String causeFileName;
    public final int causeLineNum;
    public final String fullStacktrace;
    public final String versionString;
    public final String applicationVariant;
    public final String scmString;
    public final String ciString;
    public Map<String, String> customData;
    public static final Parcelable.Creator<CrashData> CREATOR = new Parcelable.Creator<CrashData>(){

        public CrashData createFromParcel(Parcel source) {
            return new CrashData(source);
        }

        public CrashData[] newArray(int size) {
            return new CrashData[size];
        }
    };

    public CrashData(String id, long timestamp, String message, String throwableClassName, String threadName, String causeClassName, String causeMethodName, String causeFileName, int causeLineNum, String fullStacktrace, String versionString, String applicationVariant, String scmString, String ciString, Map<String, String> customData) {
        this.id = id;
        this.timestamp = timestamp;
        this.message = message;
        this.causeClassName = causeClassName;
        this.causeMethodName = causeMethodName;
        this.causeFileName = causeFileName;
        this.causeLineNum = causeLineNum;
        this.fullStacktrace = fullStacktrace;
        this.throwableClassName = throwableClassName;
        this.threadName = threadName;
        this.customData = customData == null ? Collections.emptyMap() : customData;
        this.versionString = versionString;
        this.applicationVariant = applicationVariant;
        this.scmString = scmString;
        this.ciString = ciString;
    }

    public static CrashData create(Map<String, String> map) {
        HashMap<String, String> customData = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith(ARG_CUSTOM_MAP)) continue;
            String key = entry.getKey().substring(entry.getKey().indexOf(MAP_SPLIT.charAt(0)) + 1, entry.getKey().length());
            customData.put(key, entry.getValue());
        }
        return new CrashData(map.get(ARG_ID), Long.valueOf(map.get(ARG_DATE)), map.get(ARG_MSG), map.get(ARG_THROWABLE_CLASS_NAME), map.get(ARG_THREAD_NAME), map.get(ARG_CAUSE_CLASS_NAME), map.get(ARG_CAUSE_METHOD_NAME), map.get(ARG_CAUSE_FILE_NAME), Integer.valueOf(map.get(ARG_CAUSE_LINE_NUM)), map.get(ARG_FULLSTACK), map.get(ARG_VERSION), map.get(ARG_APP_VARIANT), map.get(ARG_SCM), map.get(ARG_CI), customData);
    }

    public Map<String, String> createMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ARG_ID, this.id);
        map.put(ARG_DATE, String.valueOf(this.timestamp));
        map.put(ARG_MSG, this.message);
        map.put(ARG_THROWABLE_CLASS_NAME, this.throwableClassName);
        map.put(ARG_THREAD_NAME, this.threadName);
        map.put(ARG_CAUSE_CLASS_NAME, this.causeClassName);
        map.put(ARG_CAUSE_METHOD_NAME, this.causeMethodName);
        map.put(ARG_CAUSE_FILE_NAME, this.causeFileName);
        map.put(ARG_CAUSE_LINE_NUM, String.valueOf(this.causeLineNum));
        map.put(ARG_FULLSTACK, this.fullStacktrace);
        map.put(ARG_VERSION, this.versionString);
        map.put(ARG_APP_VARIANT, this.applicationVariant);
        map.put(ARG_SCM, this.scmString);
        map.put(ARG_CI, this.ciString);
        for (Map.Entry<String, String> entry : this.customData.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalStateException("custom map key must not be null");
            }
            map.put("ARG_CUSTOM_MAP:" + entry.getKey(), entry.getValue());
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrashData crashData = (CrashData)o;
        if (this.timestamp != crashData.timestamp) {
            return false;
        }
        if (this.causeLineNum != crashData.causeLineNum) {
            return false;
        }
        if (this.id != null ? !this.id.equals(crashData.id) : crashData.id != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(crashData.message) : crashData.message != null) {
            return false;
        }
        if (this.throwableClassName != null ? !this.throwableClassName.equals(crashData.throwableClassName) : crashData.throwableClassName != null) {
            return false;
        }
        if (this.threadName != null ? !this.threadName.equals(crashData.threadName) : crashData.threadName != null) {
            return false;
        }
        if (this.causeClassName != null ? !this.causeClassName.equals(crashData.causeClassName) : crashData.causeClassName != null) {
            return false;
        }
        if (this.causeMethodName != null ? !this.causeMethodName.equals(crashData.causeMethodName) : crashData.causeMethodName != null) {
            return false;
        }
        if (this.causeFileName != null ? !this.causeFileName.equals(crashData.causeFileName) : crashData.causeFileName != null) {
            return false;
        }
        if (this.fullStacktrace != null ? !this.fullStacktrace.equals(crashData.fullStacktrace) : crashData.fullStacktrace != null) {
            return false;
        }
        if (this.versionString != null ? !this.versionString.equals(crashData.versionString) : crashData.versionString != null) {
            return false;
        }
        if (this.applicationVariant != null ? !this.applicationVariant.equals(crashData.applicationVariant) : crashData.applicationVariant != null) {
            return false;
        }
        if (this.scmString != null ? !this.scmString.equals(crashData.scmString) : crashData.scmString != null) {
            return false;
        }
        if (this.ciString != null ? !this.ciString.equals(crashData.ciString) : crashData.ciString != null) {
            return false;
        }
        return this.customData != null ? this.customData.equals(crashData.customData) : crashData.customData == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.throwableClassName != null ? this.throwableClassName.hashCode() : 0);
        result = 31 * result + (this.threadName != null ? this.threadName.hashCode() : 0);
        result = 31 * result + (this.causeClassName != null ? this.causeClassName.hashCode() : 0);
        result = 31 * result + (this.causeMethodName != null ? this.causeMethodName.hashCode() : 0);
        result = 31 * result + (this.causeFileName != null ? this.causeFileName.hashCode() : 0);
        result = 31 * result + this.causeLineNum;
        result = 31 * result + (this.fullStacktrace != null ? this.fullStacktrace.hashCode() : 0);
        result = 31 * result + (this.versionString != null ? this.versionString.hashCode() : 0);
        result = 31 * result + (this.applicationVariant != null ? this.applicationVariant.hashCode() : 0);
        result = 31 * result + (this.scmString != null ? this.scmString.hashCode() : 0);
        result = 31 * result + (this.ciString != null ? this.ciString.hashCode() : 0);
        result = 31 * result + (this.customData != null ? this.customData.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(@NonNull CrashData crashData) {
        return Long.valueOf(crashData.timestamp).compareTo(this.timestamp);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeLong(this.timestamp);
        dest.writeString(this.message);
        dest.writeString(this.throwableClassName);
        dest.writeString(this.threadName);
        dest.writeString(this.causeClassName);
        dest.writeString(this.causeMethodName);
        dest.writeString(this.causeFileName);
        dest.writeInt(this.causeLineNum);
        dest.writeString(this.fullStacktrace);
        dest.writeString(this.versionString);
        dest.writeString(this.applicationVariant);
        dest.writeString(this.scmString);
        dest.writeString(this.ciString);
        dest.writeInt(this.customData.size());
        for (Map.Entry<String, String> entry : this.customData.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
    }

    protected CrashData(Parcel in) {
        this.id = in.readString();
        this.timestamp = in.readLong();
        this.message = in.readString();
        this.throwableClassName = in.readString();
        this.threadName = in.readString();
        this.causeClassName = in.readString();
        this.causeMethodName = in.readString();
        this.causeFileName = in.readString();
        this.causeLineNum = in.readInt();
        this.fullStacktrace = in.readString();
        this.versionString = in.readString();
        this.applicationVariant = in.readString();
        this.scmString = in.readString();
        this.ciString = in.readString();
        int customDataSize = in.readInt();
        this.customData = new HashMap<String, String>(customDataSize);
        for (int i = 0; i < customDataSize; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.customData.put(key, value);
        }
    }

    public String toString() {
        return "CrashData{id='" + this.id + '\'' + ", timestamp=" + this.timestamp + ", message='" + this.message + '\'' + ", throwableClassName='" + this.throwableClassName + '\'' + ", threadName='" + this.threadName + '\'' + ", causeClassName='" + this.causeClassName + '\'' + ", causeMethodName='" + this.causeMethodName + '\'' + ", causeFileName='" + this.causeFileName + '\'' + ", causeLineNum=" + this.causeLineNum + ", fullStacktrace='" + this.fullStacktrace + '\'' + ", versionString='" + this.versionString + '\'' + ", applicationVariant='" + this.applicationVariant + '\'' + ", scmString='" + this.scmString + '\'' + ", ciString='" + this.ciString + '\'' + ", customData=" + this.customData + '}';
    }
}

