/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb;

import android.content.Context;
import android.os.Process;
import android.util.Log;
import at.favre.lib.planb.PlanB;
import at.favre.lib.planb.PlanBConfig;
import at.favre.lib.planb.data.CrashData;
import at.favre.lib.planb.interfaces.CrashDataHandler;
import at.favre.lib.planb.interfaces.CrashRecoverBehaviour;
import at.favre.lib.planb.interfaces.ICrashExceptionData;
import at.favre.lib.planb.util.CrashDataUtil;
import java.util.Map;

final class PlanBUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = PlanBUncaughtExceptionHandler.class.getName();
    private PlanBConfig config;
    private CrashRecoverBehaviour behaviour;
    private Context context;

    PlanBUncaughtExceptionHandler(Context context, PlanBConfig config, CrashRecoverBehaviour behaviour) {
        this.config = config;
        this.context = context;
        this.behaviour = behaviour;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        try {
            CrashDataHandler crashDataHandler = PlanB.get().getCrashDataHandler();
            PlanBUncaughtExceptionHandler.log("got uncaught exception: " + throwable.getClass().getSimpleName() + ", isDebugBuild: " + PlanB.get().isDebugBuild(), this.config.enableLog);
            Map<String, String> customCrashData = null;
            if (throwable instanceof ICrashExceptionData) {
                customCrashData = ((ICrashExceptionData)((Object)throwable)).getAdditionalExceptionData();
            }
            CrashData crashData = CrashDataUtil.createFromCrash(this.config, thread, throwable, customCrashData);
            if (this.behaviour.persistCrashData()) {
                PlanBUncaughtExceptionHandler.log("persist crash data", this.config.enableLog);
                crashDataHandler.persistCrashData(crashData);
            }
            if (crashDataHandler.countOfCrashes(System.currentTimeMillis() - 1000L) >= 3) {
                PlanBUncaughtExceptionHandler.log("too many crashes in series - something seems wrong, abort custom crash ahndling", this.config.enableLog);
                PlanB.defaultUncaughtExceptionHandler.uncaughtException(thread, throwable);
                return;
            }
            this.behaviour.getPreCrashAction().onUnhandledException(this.context, thread, throwable, crashData, this.config);
            PlanBUncaughtExceptionHandler.log("handle crash", this.config.enableLog);
            this.behaviour.handleCrash(this.context, thread, throwable, crashData, this.config);
            this.behaviour.getPostCrashAction().onUnhandledException(this.context, thread, throwable, crashData, this.config);
            if (this.behaviour.callDefaultExceptionHandler()) {
                PlanBUncaughtExceptionHandler.log("call default uncaughtExceptionHandler " + PlanB.defaultUncaughtExceptionHandler.getClass().getName(), this.config.enableLog);
                PlanB.defaultUncaughtExceptionHandler.uncaughtException(thread, throwable);
            }
            if (this.behaviour.killProcess()) {
                PlanBUncaughtExceptionHandler.log("kill process", this.config.enableLog);
                Process.killProcess((int)Process.myPid());
            }
            PlanBUncaughtExceptionHandler.log("uncaught exception handling finish", this.config.enableLog);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"there was an exception in the crash recover logic", (Throwable)e);
        }
    }

    private static void log(String msg, boolean enable) {
        if (enable) {
            Log.d((String)TAG, (String)msg);
        }
    }
}

