/*
 * Decompiled with CFR 0.152.
 */
package at.favre.lib.planb;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import at.favre.lib.planb.PlanBConfig;
import at.favre.lib.planb.PlanBUncaughtExceptionHandler;
import at.favre.lib.planb.data.InMemoryCrashDataHandler;
import at.favre.lib.planb.data.SharedPrefCrashDataHandler;
import at.favre.lib.planb.interfaces.CrashDataHandler;
import at.favre.lib.planb.interfaces.CrashDataHandlerFactory;
import at.favre.lib.planb.interfaces.CrashRecoverBehaviour;
import at.favre.lib.planb.interfaces.RecoverBehaviorFactory;
import at.favre.lib.planb.recover.DefaultBehavior;
import at.favre.lib.planb.recover.StartActivityBehaviour;
import at.favre.lib.planb.recover.SuppressCrashBehaviour;

public final class PlanB {
    private static final RecoverBehaviorFactory BEHAVIOR_FACTORY = new DefaultRecoverBehaviorFactor();
    private static final CrashDataHandlerFactory CRASH_DATA_HANDLER_FACTORY = new DefaultCrashDataHandlerFactory();
    private static PlanB instance;
    static final Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler;
    private PlanBConfig config;
    private boolean isDebugBuild;

    public static RecoverBehaviorFactory behaviourFactory() {
        return BEHAVIOR_FACTORY;
    }

    public static CrashDataHandlerFactory crashDataHandlerFactory() {
        return CRASH_DATA_HANDLER_FACTORY;
    }

    public static PlanBConfig.Builder newConfig(Context context) {
        return PlanBConfig.newBuilder(context);
    }

    public static PlanB get() {
        if (instance == null) {
            instance = new PlanB();
        }
        return instance;
    }

    private PlanB() {
    }

    public void init(@NonNull Context context) {
        boolean debugBuild = 0 != (context.getApplicationInfo().flags & 2);
        this.init(context, debugBuild);
    }

    public void init(@NonNull Context context, boolean debugBuild) {
        this.init(debugBuild, PlanB.newConfig(context).build());
    }

    public void init(boolean debugBuild, @NonNull PlanBConfig config) {
        this.config = config;
        this.isDebugBuild = debugBuild;
    }

    public void enableCrashHandler(Context context, CrashRecoverBehaviour behaviour) {
        this.enableCrashHandler(context, behaviour, behaviour);
    }

    public void enableCrashHandler(Context context, CrashRecoverBehaviour debugCrashBehaviour, CrashRecoverBehaviour releaseCrashBehaviour) {
        this.checkIfInit();
        Thread.setDefaultUncaughtExceptionHandler(new PlanBUncaughtExceptionHandler(context, this.config, this.isDebugBuild ? debugCrashBehaviour : releaseCrashBehaviour));
    }

    public void disableCrashHandler() {
        Thread.setDefaultUncaughtExceptionHandler(defaultUncaughtExceptionHandler);
    }

    public boolean isDebugBuild() {
        return this.isDebugBuild;
    }

    public CrashDataHandler getCrashDataHandler() {
        this.checkIfInit();
        return this.isDebugBuild ? this.config.debugCrashDataHandler : this.config.releaseCrashDataHandler;
    }

    private void checkIfInit() {
        if (this.config == null) {
            throw new IllegalStateException("you need to init the lib first with PlanB.get().init(...)");
        }
    }

    static {
        defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    private static final class DefaultRecoverBehaviorFactor
    implements RecoverBehaviorFactory {
        private DefaultRecoverBehaviorFactor() {
        }

        @Override
        public CrashRecoverBehaviour createSuppressCrashBehaviour() {
            return new SuppressCrashBehaviour();
        }

        @Override
        public CrashRecoverBehaviour createSuppressCrashBehaviour(@Nullable CrashRecoverBehaviour.CrashAction prePostAction, @Nullable CrashRecoverBehaviour.CrashAction postCrashAction) {
            return new SuppressCrashBehaviour(prePostAction, postCrashAction);
        }

        @Override
        public CrashRecoverBehaviour createDefaultHandlerBehaviour() {
            return new DefaultBehavior();
        }

        @Override
        public CrashRecoverBehaviour createDefaultHandlerBehaviour(@Nullable CrashRecoverBehaviour.CrashAction prePostAction, @Nullable CrashRecoverBehaviour.CrashAction postCrashAction) {
            return new DefaultBehavior(prePostAction, postCrashAction);
        }

        @Override
        public CrashRecoverBehaviour createRestartForegroundActivityCrashBehaviour() {
            return new StartActivityBehaviour(0);
        }

        @Override
        public CrashRecoverBehaviour createRestartLauncherActivityCrashBehaviour() {
            return new StartActivityBehaviour(1);
        }

        @Override
        public CrashRecoverBehaviour createStartActivityCrashBehaviour(Intent intent) {
            return new StartActivityBehaviour(intent);
        }

        @Override
        public CrashRecoverBehaviour createRestartForegroundActivityCrashBehaviour(@Nullable CrashRecoverBehaviour.CrashAction prePostAction, @Nullable CrashRecoverBehaviour.CrashAction postCrashAction) {
            return new StartActivityBehaviour(0, prePostAction, postCrashAction);
        }

        @Override
        public CrashRecoverBehaviour createStartActivityCrashBehaviour(Intent intent, @Nullable CrashRecoverBehaviour.CrashAction prePostAction, @Nullable CrashRecoverBehaviour.CrashAction postCrashAction) {
            return new StartActivityBehaviour(intent, prePostAction, postCrashAction);
        }
    }

    private static final class DefaultCrashDataHandlerFactory
    implements CrashDataHandlerFactory {
        private DefaultCrashDataHandlerFactory() {
        }

        @Override
        public CrashDataHandler createSharedPrefHandler(Context ctx) {
            return new SharedPrefCrashDataHandler(ctx);
        }

        @Override
        public CrashDataHandler createSharedPrefHandler(Context ctx, int maxCapacity) {
            return new SharedPrefCrashDataHandler(ctx, maxCapacity);
        }

        @Override
        public CrashDataHandler createInMemoryHandler() {
            return new InMemoryCrashDataHandler();
        }
    }
}

