/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d.api;

import com.openhtmltopdf.java2d.api.FSPage;
import com.openhtmltopdf.java2d.api.FSPageProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class BufferedImagePageProcessor
implements FSPageProcessor {
    private final double _scale;
    private final int _imageType;
    private final List<BufferedImagePage> _pages = new ArrayList<BufferedImagePage>();

    public BufferedImagePageProcessor(int imageType, double scale) {
        this._imageType = imageType;
        this._scale = scale;
    }

    @Override
    public FSPage createPage(int zeroBasedPageNumber, int width, int height) {
        BufferedImage image = new BufferedImage((int)((double)width * this._scale), (int)((double)height * this._scale), this._imageType);
        BufferedImagePage bufferedImagePage = new BufferedImagePage(image);
        this._pages.add(bufferedImagePage);
        return bufferedImagePage;
    }

    @Override
    public void finishPage(FSPage pg) {
        BufferedImagePage page = (BufferedImagePage)pg;
        page.graphics.dispose();
        page.graphics = null;
    }

    public List<BufferedImage> getPageImages() {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        for (BufferedImagePage page : this._pages) {
            images.add(page._image);
        }
        return images;
    }

    private class BufferedImagePage
    implements FSPage {
        final BufferedImage _image;
        Graphics2D graphics;

        BufferedImagePage(BufferedImage image) {
            this._image = image;
        }

        @Override
        public Graphics2D getGraphics() {
            if (this.graphics != null) {
                return this.graphics;
            }
            this.graphics = this._image.createGraphics();
            if (this._image.getColorModel().hasAlpha()) {
                this.graphics.clearRect(0, 0, this._image.getWidth(), this._image.getHeight());
            } else {
                this.graphics.setColor(Color.WHITE);
                this.graphics.fillRect(0, 0, this._image.getWidth(), this._image.getHeight());
            }
            this.graphics.scale(BufferedImagePageProcessor.this._scale, BufferedImagePageProcessor.this._scale);
            return this.graphics;
        }
    }
}

