/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d;

import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.extend.FSObjectDrawer;
import com.openhtmltopdf.extend.FSObjectDrawerFactory;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.java2d.Java2DObjectDrawerReplacedElement;
import com.openhtmltopdf.java2d.Java2DSVGReplacedElement;
import com.openhtmltopdf.java2d.image.AWTFSImage;
import com.openhtmltopdf.java2d.image.ImageReplacedElement;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.outputdevice.helper.ExternalResourceType;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.resource.ImageResource;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class Java2DReplacedElementFactory
implements ReplacedElementFactory {
    private final SVGDrawer _svgImpl;
    private final FSObjectDrawerFactory _objectDrawerFactory;
    private final SVGDrawer _mathMLImpl;
    private final Map<SizedImageCacheKey, ReplacedElement> _sizedImageCache = new HashMap<SizedImageCacheKey, ReplacedElement>();

    public Java2DReplacedElementFactory(SVGDrawer svgImpl, FSObjectDrawerFactory objectDrawerFactory, SVGDrawer mathMLImpl) {
        this._svgImpl = svgImpl;
        this._objectDrawerFactory = objectDrawerFactory;
        this._mathMLImpl = mathMLImpl;
    }

    public ReplacedElement createReplacedElement(LayoutContext context, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("math") && this._mathMLImpl != null) {
            return new Java2DSVGReplacedElement(e, this._mathMLImpl, cssWidth, cssHeight, (Box)box, (CssContext)context);
        }
        if (nodeName.equals("svg") && this._svgImpl != null) {
            return new Java2DSVGReplacedElement(e, this._svgImpl, cssWidth, cssHeight, (Box)box, (CssContext)context);
        }
        if (nodeName.equals("object") && this._objectDrawerFactory != null) {
            FSObjectDrawer drawer = this._objectDrawerFactory.createDrawer(e);
            if (drawer != null) {
                return new Java2DObjectDrawerReplacedElement(e, drawer, cssWidth, cssHeight, context.getSharedContext().getDotsPerPixel());
            }
        } else if (nodeName.equals("img")) {
            String srcAttr = e.getAttribute("src");
            if (!srcAttr.isEmpty() && srcAttr.endsWith(".svg") && this._svgImpl != null) {
                return new Java2DSVGReplacedElement(uac.getXMLResource(srcAttr, ExternalResourceType.XML_SVG).getDocument().getDocumentElement(), this._svgImpl, cssWidth, cssHeight, (Box)box, (CssContext)context);
            }
            if (!srcAttr.isEmpty()) {
                return this.replaceImage(e, srcAttr, cssWidth, cssHeight, uac);
            }
        }
        return null;
    }

    public boolean isReplacedElement(Element e) {
        if (e == null) {
            return false;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("img")) {
            return true;
        }
        if (nodeName.equals("math") && this._mathMLImpl != null) {
            return true;
        }
        if (nodeName.equals("svg") && this._svgImpl != null) {
            return true;
        }
        if (nodeName.equals("object") && this._objectDrawerFactory != null) {
            return this._objectDrawerFactory.isReplacedObject(e);
        }
        return false;
    }

    private ReplacedElement replaceImage(Element elem, String uri, int width, int height, UserAgentCallback uac) {
        ReplacedElement replaced = this._sizedImageCache.get(new SizedImageCacheKey(uri, width, height));
        if (replaced != null) {
            return replaced;
        }
        XRLog.log((Level)Level.FINE, (LogMessageId.LogMessageId1Param)LogMessageId.LogMessageId1Param.LOAD_LOAD_IMMEDIATE_URI, (Object)uri);
        ImageResource ir = uac.getImageResource(uri);
        if (ir == null) {
            return null;
        }
        FSImage awtfsImage = ir.getImage();
        BufferedImage newImg = ((AWTFSImage)awtfsImage).getImage();
        if (newImg == null) {
            return null;
        }
        if (width > -1 || height > -1) {
            XRLog.log((Level)Level.FINE, (LogMessageId.LogMessageId4Param)LogMessageId.LogMessageId4Param.LOAD_IMAGE_LOADER_SCALING_URI_TO, (Object)this, (Object)uri, (Object)width, (Object)height);
            replaced = new ImageReplacedElement(newImg, width, height);
            this._sizedImageCache.put(new SizedImageCacheKey(uri, width, height), replaced);
        } else {
            replaced = new ImageReplacedElement(newImg, width, height);
        }
        return replaced;
    }

    private static class SizedImageCacheKey {
        final String uri;
        final int width;
        final int height;

        public SizedImageCacheKey(String uri, int width, int height) {
            this.uri = uri;
            this.width = width;
            this.height = height;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            SizedImageCacheKey cacheKey = (SizedImageCacheKey)o;
            return this.width == cacheKey.width && this.height == cacheKey.height && Objects.equals(this.uri, cacheKey.uri);
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.width, this.height);
        }
    }
}

