/*
 * Decompiled with CFR 0.152.
 */
package at.caseapps.matcha;

import android.app.Activity;
import android.content.Context;
import android.os.IBinder;
import android.support.test.InstrumentationRegistry;
import android.support.v7.widget.SearchView;
import at.caseapps.matcha.Action;
import at.caseapps.matcha.EspressoRunner;
import at.caseapps.matcha.tests.Scanner;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import org.junit.After;
import org.junit.Before;

public class MatchaEspressoTest
implements EspressoRunner.EarlGreyTestRunnerDelegate {
    private SystemAnimations systemAnimations;
    private Context context;

    @Before
    public void setup() {
        this.context = InstrumentationRegistry.getContext();
        this.systemAnimations = new SystemAnimations(this.context);
        this.systemAnimations.disableAll();
    }

    @After
    public void tearDown() {
        this.systemAnimations.enableAll();
    }

    protected void performTests(String fileName, InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream, fileName);
        if (scanner.getTestCase() == null) {
            throw new RuntimeException("No testcases found in file: " + fileName);
        }
        EspressoRunner runner = new EspressoRunner(scanner.getTestCase(), this);
        runner.start();
    }

    @Override
    public SearchView getSearchView() {
        throw new RuntimeException("Subclasses have to implement getSearchView");
    }

    @Override
    public Activity getCurrentActivity() {
        throw new RuntimeException("Subclasses have to implement getCurrentActivity");
    }

    @Override
    public boolean handles(Action action) {
        try {
            Method m = this.getClass().getMethod(action.name, Action.class);
            m.invoke((Object)this, action);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    class SystemAnimations {
        private static final String ANIMATION_PERMISSION = "android.permission.SET_ANIMATION_SCALE";
        private static final float DISABLED = 0.0f;
        private static final float DEFAULT = 1.0f;
        private final Context context;

        SystemAnimations(Context context) {
            this.context = context;
        }

        void disableAll() {
            this.setSystemAnimationsScale(0.0f);
        }

        void enableAll() {
            this.setSystemAnimationsScale(1.0f);
        }

        private void setSystemAnimationsScale(float animationScale) {
            try {
                Class<?> windowManagerStubClazz = Class.forName("android.view.IWindowManager$Stub");
                Method asInterface = windowManagerStubClazz.getDeclaredMethod("asInterface", IBinder.class);
                Class<?> serviceManagerClazz = Class.forName("android.os.ServiceManager");
                Method getService = serviceManagerClazz.getDeclaredMethod("getService", String.class);
                Class<?> windowManagerClazz = Class.forName("android.view.IWindowManager");
                Method setAnimationScales = windowManagerClazz.getDeclaredMethod("setAnimationScales", float[].class);
                Method getAnimationScales = windowManagerClazz.getDeclaredMethod("getAnimationScales", new Class[0]);
                IBinder windowManagerBinder = (IBinder)getService.invoke(null, "window");
                Object windowManagerObj = asInterface.invoke(null, windowManagerBinder);
                float[] currentScales = (float[])getAnimationScales.invoke(windowManagerObj, new Object[0]);
                for (int i = 0; i < currentScales.length; ++i) {
                    currentScales[i] = animationScale;
                }
                setAnimationScales.invoke(windowManagerObj, new Object[]{currentScales});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

