/*
 * Decompiled with CFR 0.152.
 */
package at.caseapps.matcha;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.test.espresso.Espresso;
import android.support.test.espresso.NoMatchingViewException;
import android.support.test.espresso.UiController;
import android.support.test.espresso.ViewAction;
import android.support.test.espresso.ViewAssertion;
import android.support.test.espresso.action.ViewActions;
import android.support.test.espresso.assertion.ViewAssertions;
import android.support.test.espresso.matcher.BoundedMatcher;
import android.support.test.espresso.matcher.ViewMatchers;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.view.View;
import android.webkit.WebView;
import android.widget.TextView;
import at.caseapps.matcha.Action;
import at.caseapps.matcha.Scenario;
import at.caseapps.matcha.TestCase;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class EspressoRunner {
    private TestCase testCase;
    private Scenario currentRunningScenario;
    private Action currentRunningAction;
    private EarlGreyTestRunnerDelegate delegate;

    public EspressoRunner(TestCase testCase, EarlGreyTestRunnerDelegate delegate) {
        this.testCase = testCase;
        this.delegate = delegate;
    }

    public void start() {
        Iterator<Scenario> iterator = this.testCase.scenarios.iterator();
        while (iterator.hasNext()) {
            Scenario scenario;
            this.currentRunningScenario = scenario = iterator.next();
            Iterator<Action> iterator2 = scenario.preconditions.iterator();
            while (iterator2.hasNext()) {
                Action precondition;
                this.currentRunningAction = precondition = iterator2.next();
                this.performAction(precondition);
            }
            iterator2 = scenario.steps.iterator();
            while (iterator2.hasNext()) {
                Action action;
                this.currentRunningAction = action = iterator2.next();
                this.performAction(action);
            }
        }
    }

    private void performAction(Action action) {
        try {
            if (this.delegate == null || !this.delegate.handles(action)) {
                Method m = this.getClass().getMethod(action.name, Action.class);
                m.invoke((Object)this, action);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void http(Action action) {
    }

    public void back(Action action) {
        final Activity activity = this.delegate.getCurrentActivity();
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                activity.onBackPressed();
            }
        });
    }

    public void scroll(Action action) {
        Context context = this.getCurrentContext();
        Action.ScrollAction scrollAction = (Action.ScrollAction)action;
        int id = context.getResources().getIdentifier(action.element, "id", context.getPackageName());
        int x = 0;
        int y = 0;
        if (scrollAction.direction.equals("right")) {
            x = scrollAction.amount;
        } else if (scrollAction.direction.equals("left")) {
            x = scrollAction.amount * -1;
        } else if (scrollAction.direction.equals("up")) {
            y = scrollAction.amount * -1;
        } else if (scrollAction.direction.equals("down")) {
            y = scrollAction.amount;
        }
        Espresso.onView((Matcher)ViewMatchers.withId((int)id)).perform(new ViewAction[]{new XYScrollByPositionViewAction(x, y)});
    }

    public void click(Action action) {
        Context context = this.getCurrentContext();
        int id = context.getResources().getIdentifier(action.element, "id", context.getPackageName());
        Espresso.onView((Matcher)ViewMatchers.withId((int)id)).perform(new ViewAction[]{ViewActions.click()});
    }

    public void enter(Action action) {
        Context context = this.getCurrentContext();
        Action.EnterAction enterAction = (Action.EnterAction)action;
        int id = context.getResources().getIdentifier(action.element, "id", context.getPackageName());
        Espresso.onView((Matcher)ViewMatchers.withId((int)id)).perform(new ViewAction[]{ViewActions.replaceText((String)enterAction.value)});
    }

    public void contains(Action action) {
        Context context = this.getCurrentContext();
        final Action.VerifyAction verifyAction = (Action.VerifyAction)action;
        int id = context.getResources().getIdentifier(action.element, "id", context.getPackageName());
        Espresso.onView((Matcher)ViewMatchers.withId((int)id)).check(ViewAssertions.matches((Matcher)new BoundedMatcher<View, TextView>(TextView.class){

            public void describeTo(Description description) {
                description.appendText("with text: ");
            }

            public boolean matchesSafely(TextView textView) {
                if (textView.getText() != null) {
                    return textView.getText().toString().contains(verifyAction.value);
                }
                return textView.getText() == verifyAction.value;
            }
        }));
    }

    public void wait(Action action) {
        Action.WaitAction waitAction = (Action.WaitAction)action;
        Espresso.onView((Matcher)ViewMatchers.isRoot()).perform(new ViewAction[]{EspressoRunner.waitFor((long)((Action.WaitAction)action).value)});
    }

    public void searchField(Action action) {
        Context context = this.getCurrentContext();
        Action.SearchFieldAction searchFieldAction = (Action.SearchFieldAction)action;
        if (this.delegate == null) {
            Assert.fail((String)"delegateEarlGreyTestRunnerDelegate has to be impelemented!");
            return;
        }
        this.delegate.getSearchView().setQuery((CharSequence)searchFieldAction.value, true);
        EspressoRunner.waitFor(searchFieldAction.wait);
        this.delegate.getSearchView().setIconified(true);
    }

    public void verify(Action action) {
        Context context = this.getCurrentContext();
        if (action instanceof Action.VerifyNavigationAction) {
            Action.VerifyNavigationAction verifyNavigationAction = (Action.VerifyNavigationAction)action;
            if (this.delegate.getCurrentActivity() instanceof AppCompatActivity) {
                AppCompatActivity appCompatActivity = (AppCompatActivity)this.delegate.getCurrentActivity();
                Assert.assertEquals((Object)verifyNavigationAction.navigationTitle, (Object)((AppCompatActivity)this.delegate.getCurrentActivity()).getSupportActionBar().getTitle());
            } else {
                Assert.assertEquals((Object)verifyNavigationAction.navigationTitle, (Object)this.delegate.getCurrentActivity().getActionBar().getTitle());
            }
        } else {
            Action.VerifyAction verifyAction = (Action.VerifyAction)action;
            int id = context.getResources().getIdentifier(action.element, "id", context.getPackageName());
            Espresso.onView((Matcher)ViewMatchers.withId((int)id)).check(ViewAssertions.matches((Matcher)ViewMatchers.withText((String)verifyAction.value)));
        }
    }

    public void executeJS(Action action) {
        Context context = this.getCurrentContext();
        final Action.ExecuteJSAction executeJSAction = (Action.ExecuteJSAction)action;
        int id = context.getResources().getIdentifier(action.element, "id", context.getPackageName());
        Espresso.onView((Matcher)ViewMatchers.withId((int)id)).perform(new ViewAction[]{new ViewAction(){

            public Matcher<View> getConstraints() {
                return ViewMatchers.isAssignableFrom(WebView.class);
            }

            public String getDescription() {
                return "execute JS";
            }

            public void perform(UiController uiController, View view) {
                WebView webView = (WebView)view;
                if (Build.VERSION.SDK_INT >= 19) {
                    webView.evaluateJavascript(executeJSAction.code, null);
                } else {
                    webView.loadUrl("javascript:" + executeJSAction.code);
                }
            }
        }});
    }

    private Context getCurrentContext() {
        final Context[] context = new Context[1];
        Espresso.onView((Matcher)ViewMatchers.isRoot()).check(new ViewAssertion(){

            public void check(View view, NoMatchingViewException noViewFoundException) {
                context[0] = view.getContext();
            }
        });
        return context[0];
    }

    public static ViewAction waitFor(final double seconds) {
        return new ViewAction(){

            public Matcher<View> getConstraints() {
                return ViewMatchers.isRoot();
            }

            public String getDescription() {
                return "Wait for " + seconds * 1000.0 + " milliseconds.";
            }

            public void perform(UiController uiController, View view) {
                uiController.loopMainThreadForAtLeast((long)(seconds * 1000.0));
            }
        };
    }

    private static final class XYScrollByPositionViewAction
    implements ViewAction {
        private final int x;
        private final int y;

        private XYScrollByPositionViewAction(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public Matcher<View> getConstraints() {
            return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(RecyclerView.class), (Matcher)ViewMatchers.isDisplayed());
        }

        public String getDescription() {
            return "scroll RecyclerView by " + this.x + "/" + this.y;
        }

        public void perform(UiController uiController, View view) {
            RecyclerView recyclerView = (RecyclerView)view;
            recyclerView.scrollBy(this.x, this.y);
        }
    }

    public static interface EarlGreyTestRunnerDelegate {
        public boolean handles(Action var1);

        public SearchView getSearchView();

        public Activity getCurrentActivity();
    }
}

