/*
 * Decompiled with CFR 0.152.
 */
package at.blogc.android.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.TextView;
import at.blogc.expandabletextview.R;
import java.lang.reflect.Field;

public class ExpandableTextView
extends TextView {
    private static final int MAXMODE_LINES = 1;
    private OnExpandListener onExpandListener;
    private TimeInterpolator expandInterpolator;
    private TimeInterpolator collapseInterpolator;
    private final int maxLines;
    private long animationDuration;
    private boolean animating;
    private boolean expanded;
    private int collapsedHeight;

    public ExpandableTextView(Context context) {
        this(context, null);
    }

    public ExpandableTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExpandableTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.ExpandableTextView, defStyle, 0);
        this.animationDuration = attributes.getInt(R.styleable.ExpandableTextView_animation_duration, 750);
        attributes.recycle();
        this.maxLines = this.getMaxLines();
        this.expandInterpolator = new AccelerateDecelerateInterpolator();
        this.collapseInterpolator = new AccelerateDecelerateInterpolator();
    }

    public int getMaxLines() {
        if (Build.VERSION.SDK_INT >= 16) {
            return super.getMaxLines();
        }
        try {
            Field mMaxMode = TextView.class.getField("mMaxMode");
            mMaxMode.setAccessible(true);
            Field mMaximum = TextView.class.getField("mMaximum");
            mMaximum.setAccessible(true);
            int mMaxModeValue = (Integer)mMaxMode.get((Object)this);
            int mMaximumValue = (Integer)mMaximum.get((Object)this);
            return mMaxModeValue == 1 ? mMaximumValue : -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean toggle() {
        return this.expanded ? this.collapse() : this.expand();
    }

    public boolean expand() {
        if (!this.expanded && !this.animating && this.maxLines >= 0) {
            this.animating = true;
            if (this.onExpandListener != null) {
                this.onExpandListener.onExpand(this);
            }
            this.measure(View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            this.collapsedHeight = this.getMeasuredHeight();
            this.setMaxLines(Integer.MAX_VALUE);
            this.measure(View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            int expandedHeight = this.getMeasuredHeight();
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{this.collapsedHeight, expandedHeight});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ViewGroup.LayoutParams layoutParams = ExpandableTextView.this.getLayoutParams();
                    layoutParams.height = (Integer)animation.getAnimatedValue();
                    ExpandableTextView.this.setLayoutParams(layoutParams);
                }
            });
            valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    ViewGroup.LayoutParams layoutParams = ExpandableTextView.this.getLayoutParams();
                    layoutParams.height = -2;
                    ExpandableTextView.this.setLayoutParams(layoutParams);
                    ExpandableTextView.this.expanded = true;
                    ExpandableTextView.this.animating = false;
                }
            });
            valueAnimator.setInterpolator(this.expandInterpolator);
            valueAnimator.setDuration(this.animationDuration).start();
            return true;
        }
        return false;
    }

    public boolean collapse() {
        if (this.expanded && !this.animating && this.maxLines >= 0) {
            this.animating = true;
            if (this.onExpandListener != null) {
                this.onExpandListener.onCollapse(this);
            }
            int expandedHeight = this.getMeasuredHeight();
            ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{expandedHeight, this.collapsedHeight});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ViewGroup.LayoutParams layoutParams = ExpandableTextView.this.getLayoutParams();
                    layoutParams.height = (Integer)animation.getAnimatedValue();
                    ExpandableTextView.this.setLayoutParams(layoutParams);
                }
            });
            valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    ExpandableTextView.this.setMaxLines(ExpandableTextView.this.maxLines);
                    ViewGroup.LayoutParams layoutParams = ExpandableTextView.this.getLayoutParams();
                    layoutParams.height = -2;
                    ExpandableTextView.this.setLayoutParams(layoutParams);
                    ExpandableTextView.this.expanded = false;
                    ExpandableTextView.this.animating = false;
                }
            });
            valueAnimator.setInterpolator(this.collapseInterpolator);
            valueAnimator.setDuration(this.animationDuration).start();
            return true;
        }
        return false;
    }

    public void setAnimationDuration(long animationDuration) {
        this.animationDuration = animationDuration;
    }

    public void setOnExpandListener(OnExpandListener onExpandListener) {
        this.onExpandListener = onExpandListener;
    }

    public OnExpandListener getOnExpandListener() {
        return this.onExpandListener;
    }

    public void setInterpolator(TimeInterpolator interpolator) {
        this.expandInterpolator = interpolator;
        this.collapseInterpolator = interpolator;
    }

    public void setExpandInterpolator(TimeInterpolator expandInterpolator) {
        this.expandInterpolator = expandInterpolator;
    }

    public TimeInterpolator getExpandInterpolator() {
        return this.expandInterpolator;
    }

    public void setCollapseInterpolator(TimeInterpolator collapseInterpolator) {
        this.collapseInterpolator = collapseInterpolator;
    }

    public TimeInterpolator getCollapseInterpolator() {
        return this.collapseInterpolator;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public static interface OnExpandListener {
        public void onExpand(ExpandableTextView var1);

        public void onCollapse(ExpandableTextView var1);
    }
}

