/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.execution;

import android.text.TextUtils;
import android.util.Log;
import at.amartinz.execution.Command;
import at.amartinz.execution.IoUtils;
import at.amartinz.execution.ShellLogger;
import at.amartinz.execution.exceptions.RootDeniedException;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public abstract class Shell {
    private static final String TAG = Shell.class.getSimpleName();
    public static final int DEFAULT_TIMEOUT = 15000;
    private static final String ENCODING = "UTF-8";
    private static final String TOKEN = "Y#*N^W^T@#@G";
    public int shellTimeout = 15000;
    public boolean isRoot;
    private boolean isCleaning;
    private boolean isClosed;
    private boolean isExecuting;
    public String error;
    private final Process process;
    private final InputStreamReader inputStreamReader;
    private final BufferedReader inputStream;
    private final InputStreamReader errorStreamReader;
    private final BufferedReader errorStream;
    private final OutputStreamWriter outputStream;
    private boolean shouldClose;
    private final List<Command> commands = new ArrayList<Command>();
    private final int maxCommands = 1000;
    private int totalExecuted;
    private int toWrite;
    private int totalRead;
    private int toRead;
    private final Runnable inputRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    List list = Shell.this.commands;
                    synchronized (list) {
                        while (!Shell.this.shouldClose && Shell.this.toWrite >= Shell.this.commands.size()) {
                            Shell.this.isExecuting = false;
                            Shell.this.commands.wait();
                        }
                    }
                    if (Shell.this.toWrite >= 1000) {
                        if (ShellLogger.DEBUG && Shell.this.toRead != Shell.this.toWrite) {
                            Log.v((String)TAG, (String)"Waiting for r/w to catch up before cleanup");
                        }
                        while (Shell.this.toRead != Shell.this.toWrite) {
                        }
                        Shell.this.cleanupCommands();
                    }
                    if (Shell.this.toWrite < Shell.this.commands.size()) {
                        String[] toExecute;
                        Shell.this.isExecuting = true;
                        Command cmd = (Command)Shell.this.commands.get(Shell.this.toWrite);
                        cmd.startExecution();
                        for (String cmdToExecute : toExecute = cmd.getCommands()) {
                            if (TextUtils.isEmpty((CharSequence)cmdToExecute)) continue;
                            Shell.this.outputStream.write(cmdToExecute);
                        }
                        String line = String.format("\necho %s %s $?\n", Shell.TOKEN, Shell.this.totalExecuted);
                        Shell.this.outputStream.write(line);
                        Shell.this.outputStream.flush();
                        Shell.this.toWrite++;
                        Shell.this.totalExecuted++;
                        continue;
                    }
                    if (Shell.this.shouldClose) break;
                }
                Shell.this.isExecuting = false;
                Shell.this.outputStream.write("\nexit 0\n");
                Shell.this.outputStream.flush();
                return;
            }
            catch (IOException | InterruptedException e) {
                if (ShellLogger.DEBUG) {
                    Log.e((String)TAG, (String)"IOException | InterruptedException", (Throwable)e);
                }
            }
            finally {
                Shell.this.toWrite = 0;
                Shell.this.closeStreams();
            }
        }
    };
    private final Runnable outputRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Command command = null;
            try {
                String outputLine22;
                while ((!Shell.this.shouldClose || Shell.this.inputStream.ready() || Shell.this.toRead < Shell.this.commands.size()) && (outputLine22 = Shell.this.inputStream.readLine()) != null) {
                    String[] fields;
                    int pos;
                    if (command == null) {
                        if (Shell.this.toRead >= Shell.this.commands.size()) {
                            if (!Shell.this.shouldClose) continue;
                            break;
                        }
                        command = (Command)Shell.this.commands.get(Shell.this.toRead);
                    }
                    if ((pos = outputLine22.indexOf(Shell.TOKEN)) == -1) {
                        command.doOutput(command.id, outputLine22);
                    } else if (pos > 0) {
                        command.doOutput(command.id, outputLine22.substring(0, pos));
                    }
                    if (pos < 0 || (fields = (outputLine22 = outputLine22.substring(pos)).split(" ")).length < 2 || fields[1] == null) continue;
                    int id = 0;
                    try {
                        id = Integer.parseInt(fields[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    int exitCode = -1;
                    try {
                        exitCode = Integer.parseInt(fields[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (id != Shell.this.totalRead) continue;
                    Shell.this.processErrors(command);
                    int iterations = 0;
                    while (command.totalOutput > command.totalOutputProcessed) {
                        if (iterations == 0) {
                            ++iterations;
                        }
                        3 var8_12 = this;
                        synchronized (var8_12) {
                            try {
                                this.wait(Shell.this.shellTimeout);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    command.setExitCode(exitCode);
                    command.commandFinished();
                    command = null;
                    Shell.this.toRead++;
                    Shell.this.totalRead++;
                }
                try {
                    Shell.this.process.waitFor();
                    Shell.this.process.destroy();
                }
                catch (Exception outputLine22) {
                    // empty catch block
                }
                while (Shell.this.toRead < Shell.this.commands.size()) {
                    if (command == null) {
                        command = (Command)Shell.this.commands.get(Shell.this.toRead);
                    }
                    if (command.totalOutput < command.totalOutputProcessed) {
                        command.terminate("Did not process all doOutput!");
                    } else {
                        command.terminate("Unexpected termination!");
                    }
                    command = null;
                    Shell.this.toRead++;
                }
                Shell.this.toRead = 0;
            }
            catch (IOException e) {
                if (ShellLogger.DEBUG) {
                    Log.e((String)TAG, (String)"IOException", (Throwable)e);
                }
            }
            finally {
                Shell.this.closeStreams();
                Shell.this.isClosed = true;
            }
        }
    };

    protected Shell(boolean isRoot) throws IOException, TimeoutException, RootDeniedException {
        this.isRoot = isRoot;
        String cmd = isRoot ? "su" : "/system/bin/sh";
        this.process = Runtime.getRuntime().exec(cmd);
        this.inputStreamReader = new InputStreamReader(this.process.getInputStream(), ENCODING);
        this.inputStream = new BufferedReader(this.inputStreamReader);
        this.errorStreamReader = new InputStreamReader(this.process.getErrorStream(), ENCODING);
        this.errorStream = new BufferedReader(this.errorStreamReader);
        this.outputStream = new OutputStreamWriter(this.process.getOutputStream(), ENCODING);
        Worker worker = new Worker(this);
        worker.start();
        try {
            worker.join(this.shellTimeout);
            switch (worker.exitCode) {
                case -10239: {
                    try {
                        this.process.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.closeStreams();
                    throw new TimeoutException(this.error);
                }
                case -10339: {
                    try {
                        this.process.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.closeStreams();
                    throw new RootDeniedException(this.error);
                }
            }
            Thread inputThread = new Thread(this.inputRunnable, "Shell input");
            inputThread.setPriority(5);
            inputThread.start();
            Thread outputThread = new Thread(this.outputRunnable, "Shell doOutput");
            inputThread.setPriority(5);
            outputThread.start();
        }
        catch (InterruptedException ie) {
            worker.interrupt();
            Thread.currentThread().interrupt();
            throw new TimeoutException();
        }
    }

    public synchronized boolean isCleaning() {
        return this.isCleaning;
    }

    public synchronized boolean shouldClose() {
        return this.shouldClose;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized boolean isExecuting() {
        return this.isExecuting;
    }

    public Command add(Command command) {
        if (this.shouldClose) {
            throw new IllegalStateException("Unable to add commands to a closed shell");
        }
        while (this.isCleaning()) {
        }
        command.resetCommand();
        this.commands.add(command);
        this.notifyThreads();
        return command;
    }

    protected static Command fireAndBlockInternal(Command command, Shell shell) {
        return shell.add(command).waitFor();
    }

    protected static Command fireAndBlockStringInternal(Command command, Shell shell) {
        return shell.add(command.setOutputType(2)).waitFor();
    }

    protected static Command fireAndBlockStringNewlineInternal(Command command, Shell shell) {
        return shell.add(command.setOutputType(3)).waitFor();
    }

    protected static Command fireAndBlockListInternal(Command command, Shell shell) {
        return shell.add(command.setOutputType(4)).waitFor();
    }

    protected static Command fireAndForgetInternal(Command command, Shell shell) {
        return shell.add(command);
    }

    protected void notifyThreads() {
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = Shell.this.commands;
                synchronized (list) {
                    Shell.this.commands.notifyAll();
                }
            }
        });
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        int count = 0;
        while (this.isExecuting()) {
            if (ShellLogger.DEBUG) {
                Log.v((String)TAG, (String)"Waiting on shell to finish executing before closing...");
            }
            if (++count <= 10000) continue;
        }
        List<Command> list = this.commands;
        synchronized (list) {
            this.shouldClose = true;
            this.notifyThreads();
        }
        if (ShellLogger.DEBUG) {
            Log.v((String)TAG, (String)String.format("Shell closed! - %s", this));
        }
    }

    private void closeStreams() {
        IoUtils.closeQuietly(this.inputStream);
        IoUtils.closeQuietly(this.inputStreamReader);
        IoUtils.closeQuietly(this.errorStream);
        IoUtils.closeQuietly(this.errorStreamReader);
        IoUtils.closeQuietly(this.outputStream);
    }

    private synchronized void cleanupCommands() {
        this.isCleaning = true;
        int toClean = Math.abs(this.maxCommands - this.maxCommands / 4);
        if (ShellLogger.DEBUG) {
            Log.v((String)TAG, (String)String.format("Cleaning up: %s", toClean));
        }
        for (int i = 0; i < toClean; ++i) {
            this.commands.remove(0);
        }
        this.toRead = this.toWrite = this.commands.size() - 1;
        this.isCleaning = false;
    }

    public void processErrors(Command command) {
        block3: {
            try {
                String line;
                while (this.errorStream.ready() && command != null && (line = this.errorStream.readLine()) != null) {
                    command.doOutput(command.id, line);
                }
            }
            catch (Exception e) {
                if (!ShellLogger.DEBUG) break block3;
                Log.e((String)TAG, (String)"Error while processing errors. Can you see the irony?", (Throwable)e);
            }
        }
    }

    protected static class Worker
    extends Thread {
        private static final String OPENING = "echo Opening\n";
        public static final int EXIT_TIMEOUT = -10239;
        public static final int EXIT_ERROR = -10339;
        public static final int EXIT_SUCCESS = 1;
        public final Shell shell;
        private int exitCode;

        private Worker(Shell shell) {
            this.shell = shell;
            this.exitCode = -10239;
        }

        @Override
        public void run() {
            try {
                String line;
                this.shell.outputStream.write(OPENING);
                this.shell.outputStream.flush();
                do {
                    if ((line = this.shell.inputStream.readLine()) != null) continue;
                    throw new EOFException();
                } while ("".equals(line) || !"Opening".equals(line));
                this.exitCode = 1;
                this.setupShellOom();
                this.shell.error = "Unknown error occurred";
            }
            catch (IOException ioe) {
                this.exitCode = -10339;
                StringBuilder sb = new StringBuilder();
                sb.append("Could not open shell -> ").append(ioe.getMessage()).append('\n');
                if (this.shell.isRoot) {
                    sb.append("Maybe root got denied?\n");
                }
                this.shell.error = sb.toString();
            }
        }

        private void setupShellOom() {
            block16: {
                int pid;
                block15: {
                    Field field;
                    Class<?> processClass = this.shell.process.getClass();
                    try {
                        field = processClass.getDeclaredField("pid");
                    }
                    catch (NoSuchFieldException e) {
                        try {
                            field = processClass.getDeclaredField("id");
                        }
                        catch (NoSuchFieldException e1) {
                            field = null;
                        }
                    }
                    if (field != null) {
                        field.setAccessible(true);
                        try {
                            pid = (Integer)field.get(this.shell.process);
                        }
                        catch (IllegalAccessException iae) {
                            if (ShellLogger.DEBUG) {
                                Log.e((String)TAG, (String)"IllegalAccessException", (Throwable)iae);
                            }
                            pid = -1;
                        }
                    } else {
                        pid = -1;
                    }
                    if (pid == -1) {
                        if (ShellLogger.DEBUG) {
                            Log.e((String)TAG, (String)"could not get pid via reflection!");
                        }
                        return;
                    }
                    try {
                        this.setupOomAdj(pid);
                    }
                    catch (Exception e) {
                        if (!ShellLogger.DEBUG) break block15;
                        Log.e((String)TAG, (String)String.format("Could not set shell oom adj for pid %s!", pid), (Throwable)e);
                    }
                }
                try {
                    this.setupOomScoreAdj(pid);
                }
                catch (Exception e) {
                    if (!ShellLogger.DEBUG) break block16;
                    Log.e((String)TAG, (String)String.format("Could not set shell oom score adj for pid %s!", pid), (Throwable)e);
                }
            }
        }

        private void setupOomAdj(int pid) throws Exception {
            this.shell.outputStream.write("(echo -17 > /proc/" + pid + "/oom_adj) &> /dev/null\n");
            this.shell.outputStream.write("(echo -17 > /proc/$$/oom_adj) &> /dev/null\n");
            this.shell.outputStream.flush();
        }

        private void setupOomScoreAdj(int pid) throws Exception {
            this.shell.outputStream.write("(echo -1000 > /proc/" + pid + "/oom_score_adj) &> /dev/null\n");
            this.shell.outputStream.write("(echo -1000 > /proc/$$/oom_score_adj) &> /dev/null\n");
            this.shell.outputStream.flush();
        }
    }
}

