/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.execution;

import android.support.annotation.Nullable;
import android.util.Log;
import at.amartinz.execution.CommandListener;
import at.amartinz.execution.ShellLogger;
import java.util.ArrayList;
import java.util.List;

public class Command
implements CommandListener {
    private static final String TAG = Command.class.getSimpleName();
    public static final int OUTPUT_NONE = -1;
    public static final int OUTPUT_ALL = 1;
    public static final int OUTPUT_STRING = 2;
    public static final int OUTPUT_STRING_NEWLINE = 3;
    public static final int OUTPUT_LIST = 4;
    public int id;
    public int exitCode;
    private final int timeout;
    private boolean isExecuting;
    private boolean isFinished;
    private boolean isTerminated;
    public int totalOutput;
    public int totalOutputProcessed;
    private String[] commands;
    private int outputType = -1;
    private StringBuilder outputBuilder;
    private List<String> outputList;

    public Command(String ... commands) {
        this(0, 15000, commands);
    }

    public Command(int id, String ... commands) {
        this(id, 15000, commands);
    }

    public Command(int id, int timeout, String ... commands) {
        this.id = id;
        this.timeout = timeout;
        this.commands = commands;
    }

    public final String[] getCommands() {
        if (this.commands == null || this.commands.length == 0) {
            throw new RuntimeException("No commands?");
        }
        return this.commands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command waitFor() {
        while (!this.isFinished()) {
            Command command = this;
            synchronized (command) {
                try {
                    this.wait(this.timeout);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.isFinished() || this.isExecuting() || !ShellLogger.RAMPAGE) continue;
            throw new RuntimeException("Something is really wrong");
        }
        return this;
    }

    public final synchronized boolean isExecuting() {
        return this.isExecuting;
    }

    public final synchronized boolean isFinished() {
        return this.isFinished;
    }

    public final synchronized boolean isTerminated() {
        return this.isTerminated;
    }

    public synchronized Command setOutputType(int outputType) {
        this.outputType = outputType;
        switch (this.outputType) {
            default: {
                this.outputBuilder = null;
                this.outputList = null;
                break;
            }
            case 1: {
                this.outputBuilder = new StringBuilder();
                this.outputList = new ArrayList<String>();
                break;
            }
            case 2: 
            case 3: {
                this.outputBuilder = new StringBuilder();
                this.outputList = null;
                break;
            }
            case 4: {
                this.outputBuilder = null;
                this.outputList = new ArrayList<String>();
            }
        }
        return this;
    }

    public final synchronized int getExitCode() {
        return this.exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setExitCode(int code) {
        Command command = this;
        synchronized (command) {
            this.exitCode = code;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doOutput(int id, String line) {
        ++this.totalOutput;
        Command command = this;
        synchronized (command) {
            this.onCommandOutput(id, line);
        }
    }

    public final synchronized void resetCommand() {
        this.isFinished = false;
        this.totalOutput = 0;
        this.totalOutputProcessed = 0;
        this.isExecuting = false;
        this.isTerminated = false;
        this.exitCode = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void commandFinished() {
        if (!this.isTerminated()) {
            Command command = this;
            synchronized (command) {
                this.onCommandCompleted(this.id, this.exitCode);
                if (ShellLogger.DEBUG) {
                    Log.v((String)TAG, (String)String.format("finished command with id \"%s\"", this.id));
                }
                this.finishCommand();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finishCommand() {
        Command command = this;
        synchronized (command) {
            this.isExecuting = false;
            this.isFinished = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void terminate(String reason) {
        Command command = this;
        synchronized (command) {
            this.onCommandTerminated(this.id, reason);
            if (ShellLogger.DEBUG) {
                Log.w((String)TAG, (String)String.format("command \"%s\" did not finish because it was terminated!\n%s", this.id, reason));
            }
            this.setExitCode(-1);
            this.isTerminated = true;
            this.finishCommand();
        }
    }

    protected final void startExecution() {
        ExecutionMonitor executionMonitor = new ExecutionMonitor();
        executionMonitor.setPriority(1);
        executionMonitor.start();
        this.isExecuting = true;
    }

    @Override
    public void onCommandCompleted(int id, int exitCode) {
        this.setExitCode(exitCode);
    }

    @Override
    public void onCommandTerminated(int id, String reason) {
        if (ShellLogger.DEBUG) {
            Log.v((String)TAG, (String)String.format("terminated command with id \"%s\": %s", id, reason));
        }
    }

    @Override
    public void onCommandOutput(int id, String line) {
        if (this.outputBuilder != null) {
            this.outputBuilder.append(line);
            if (this.outputType == 3) {
                this.outputBuilder.append('\n');
            }
        }
        if (this.outputList != null) {
            this.outputList.add(line);
        }
        ++this.totalOutputProcessed;
    }

    @Nullable
    public String getOutput() {
        return this.outputBuilder != null ? this.outputBuilder.toString().trim() : null;
    }

    @Nullable
    public List<String> getOutputList() {
        return this.outputList;
    }

    private class ExecutionMonitor
    extends Thread {
        private ExecutionMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Command.this.timeout <= 0) {
                return;
            }
            while (!Command.this.isFinished()) {
                Command command = Command.this;
                synchronized (command) {
                    try {
                        Command.this.wait(Command.this.timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (Command.this.isFinished()) continue;
                Command.this.terminate("Timeout exception");
            }
        }
    }
}

