/*
 * Decompiled with CFR 0.152.
 */
package at.amartinz.execution;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import at.amartinz.execution.ShellHelper;
import at.amartinz.execution.ShellLogger;
import java.io.File;

public class BusyBox {
    private static final String TAG = BusyBox.class.getSimpleName();
    private static final String PLAY_STORE_BUSYBOX = "https://play.google.com/store/apps/details?id=stericson.busybox";
    private static final String[] PATH_BUSYBOX = new String[]{"/system/bin/busybox", "/system/xbin/busybox"};
    private static final String[] PATH_TOYBOX = new String[]{"/system/bin/toybox", "/system/xbin/toybox"};
    private static Boolean sHasBusybox = null;
    private static String sBusyBoxPath = null;

    public static boolean isAvailable() {
        return BusyBox.isAvailable(false);
    }

    public static boolean isAvailable(boolean forceCheck) {
        String toyboxLocation;
        String busyboxLocation;
        String toyboxPath;
        if (!forceCheck && sHasBusybox != null) {
            return sHasBusybox;
        }
        String busyboxPath = BusyBox.getBusyboxPath();
        if (!TextUtils.isEmpty((CharSequence)busyboxPath)) {
            if (ShellLogger.DEBUG) {
                Log.d((String)TAG, (String)String.format("Found busybox path: %s", busyboxPath));
            }
            sHasBusybox = true;
            sBusyBoxPath = busyboxPath;
            return true;
        }
        if (ShellLogger.DEBUG) {
            Log.d((String)TAG, (String)"no busybox binary found, trying with toybox");
        }
        if (!TextUtils.isEmpty((CharSequence)(toyboxPath = BusyBox.getToyboxPath()))) {
            if (ShellLogger.DEBUG) {
                Log.d((String)TAG, (String)String.format("Found toybox path: %s", toyboxPath));
            }
            sHasBusybox = true;
            sBusyBoxPath = toyboxPath;
            return true;
        }
        if (ShellLogger.DEBUG) {
            Log.d((String)TAG, (String)"no busybox nor toybox binary found, trying with hit and miss");
        }
        if (!TextUtils.isEmpty((CharSequence)(busyboxLocation = ShellHelper.findBinary("busybox")))) {
            if (ShellLogger.DEBUG) {
                Log.d((String)TAG, (String)String.format("Found busybox path: %s", busyboxLocation));
            }
            sHasBusybox = true;
            sBusyBoxPath = busyboxLocation.endsWith("/") ? String.format("%s%s", busyboxLocation, "busybox") : String.format("%s/%s", busyboxLocation, "busybox");
            return true;
        }
        if (ShellLogger.DEBUG) {
            Log.d((String)TAG, (String)"no busybox via hit and miss found, come on toybox...");
        }
        if (!TextUtils.isEmpty((CharSequence)(toyboxLocation = ShellHelper.findBinary("toybox")))) {
            if (ShellLogger.DEBUG) {
                Log.d((String)TAG, (String)String.format("Found toybox path: %s", toyboxLocation));
            }
            sHasBusybox = true;
            sBusyBoxPath = toyboxLocation.endsWith("/") ? String.format("%s%s", toyboxLocation, "toybox") : String.format("%s/%s", toyboxLocation, "toybox");
            return true;
        }
        if (ShellLogger.DEBUG) {
            Log.d((String)TAG, (String)"alright, i give up. no busybox or toybox detected.");
        }
        sHasBusybox = false;
        sBusyBoxPath = null;
        return false;
    }

    public static boolean isActuallyToybox() {
        return !TextUtils.isEmpty((CharSequence)sBusyBoxPath) && sBusyBoxPath.endsWith("toybox");
    }

    @Nullable
    public static String getBusyboxPath() {
        for (String path : PATH_BUSYBOX) {
            if (!new File(path).exists()) continue;
            return path;
        }
        return null;
    }

    @Nullable
    public static String getToyboxPath() {
        for (String path : PATH_TOYBOX) {
            if (!new File(path).exists()) continue;
            return path;
        }
        return null;
    }

    @Nullable
    public static String callBusyBoxApplet(@NonNull String applet) {
        return BusyBox.callBusyBoxApplet(applet, null);
    }

    @Nullable
    public static String callBusyBoxApplet(@NonNull String applet, @Nullable String args) {
        if (!BusyBox.isAvailable() || TextUtils.isEmpty((CharSequence)sBusyBoxPath)) {
            return null;
        }
        String cmd = String.format("%s %s", sBusyBoxPath, applet);
        if (TextUtils.isEmpty((CharSequence)args)) {
            Log.v((String)TAG, (String)String.format("No args specified, returning -> %s", cmd));
            return cmd;
        }
        cmd = String.format("%s %s", cmd, args);
        if (ShellLogger.DEBUG) {
            Log.v((String)TAG, (String)String.format("Calling applet \"%s\" with args -> %s", applet, args));
        }
        return cmd;
    }

    @Nullable
    public static String callBusyBoxAppletInternal(@NonNull Context context, @NonNull String applet) {
        return BusyBox.callBusyBoxAppletInternal(context, applet, null);
    }

    @Nullable
    public static String callBusyBoxAppletInternal(@NonNull Context context, @NonNull String applet, @Nullable String args) {
        File fileDir = context.getFilesDir();
        if (!fileDir.exists()) {
            if (ShellLogger.DEBUG) {
                Log.e((String)TAG, (String)"Files folder does not exist!");
            }
            return null;
        }
        File busybox = new File(fileDir, "busybox");
        if (!busybox.exists()) {
            Log.e((String)TAG, (String)"busybox binary does not exist!");
            return null;
        }
        String cmd = String.format("%s %s", busybox.getAbsolutePath(), applet);
        if (TextUtils.isEmpty((CharSequence)args)) {
            Log.v((String)TAG, (String)String.format("No args specified, returning -> %s", cmd));
            return cmd;
        }
        cmd = String.format("%s %s", cmd, args);
        if (ShellLogger.DEBUG) {
            Log.v((String)TAG, (String)String.format("Calling applet \"%s\" with args -> %s", applet, args));
        }
        return cmd;
    }

    public static void offerBusyBox(@NonNull Context context) {
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)PLAY_STORE_BUSYBOX));
        i.setFlags(0x10000000);
        try {
            context.startActivity(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

