/*
 * Decompiled with CFR 0.152.
 */
package at.allaboutapps.web.webview;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.webkit.WebView;
import at.allaboutapps.web.webview.DataWebViewLoadingMethod;
import at.allaboutapps.web.webview.R;
import at.allaboutapps.web.webview.UrlWebViewLoadingMethod;

public class WebViewSettings
implements Parcelable {
    public static final Parcelable.Creator<WebViewSettings> CREATOR = new Parcelable.Creator<WebViewSettings>(){

        public WebViewSettings createFromParcel(Parcel source) {
            return new WebViewSettings(source);
        }

        public WebViewSettings[] newArray(int size) {
            return new WebViewSettings[size];
        }
    };
    public static final String PATH_TO_ASSETS = "file:///android_asset/";
    private static final String MIME_TEXT_HTML = "text/html";
    private static final String CHARSET_UTF_8 = "UTF-8";
    final WebViewLoadingMethod loadingMethod;
    boolean showLoading = true;
    boolean javaScriptEnabled = false;
    boolean openLinksExternally = false;
    int errorLayout = R.layout.a3_webview_error_layout;

    private WebViewSettings(@NonNull WebViewLoadingMethod urlLoadingMethod) {
        this.loadingMethod = urlLoadingMethod;
    }

    protected WebViewSettings(Parcel in) {
        this.showLoading = in.readByte() != 0;
        this.javaScriptEnabled = in.readByte() != 0;
        this.openLinksExternally = in.readByte() != 0;
        this.errorLayout = in.readInt();
        this.loadingMethod = (WebViewLoadingMethod)in.readParcelable(WebViewLoadingMethod.class.getClassLoader());
    }

    public static WebViewSettings loadUrl(String url) {
        return new WebViewSettings(new UrlWebViewLoadingMethod(url));
    }

    public static WebViewSettings loadAssetFile(String assetFilePath) {
        return WebViewSettings.loadUrl(PATH_TO_ASSETS + assetFilePath);
    }

    public static WebViewSettings loadData(@NonNull String data) {
        return new WebViewSettings(new DataWebViewLoadingMethod(data, MIME_TEXT_HTML, CHARSET_UTF_8));
    }

    public static WebViewSettings loadData(@NonNull String data, String baseUrl) {
        return new WebViewSettings(new DataWebViewLoadingMethod(data, MIME_TEXT_HTML, CHARSET_UTF_8, baseUrl));
    }

    public static WebViewSettings using(@NonNull WebViewLoadingMethod loadingMethod) {
        return new WebViewSettings(loadingMethod);
    }

    public WebViewSettings disableLoadingIndicator() {
        this.showLoading = false;
        return this;
    }

    public WebViewSettings enableJavaScript() {
        this.javaScriptEnabled = true;
        return this;
    }

    public WebViewSettings openLinksExternally() {
        this.openLinksExternally = true;
        return this;
    }

    public WebViewSettings setErrorLayoutId(@LayoutRes int layoutResId) {
        this.errorLayout = layoutResId;
        return this;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.showLoading ? (byte)1 : 0);
        dest.writeByte(this.javaScriptEnabled ? (byte)1 : 0);
        dest.writeByte(this.openLinksExternally ? (byte)1 : 0);
        dest.writeInt(this.errorLayout);
        dest.writeParcelable((Parcelable)this.loadingMethod, flags);
    }

    public static interface WebViewLoadingMethod
    extends Parcelable {
        public void startLoading(WebView var1);
    }
}

