/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.lablink.clients.redisclient;

import at.ac.ait.lablink.core.utility.Utility;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class RedisOpalConfig {
    protected static final int MS_TIME_INTERVAL_DEFAULT = 5000;
    public ArrayList<String> commands;
    public ArrayList<String> measurements;
    public String groupName;
    public String clientName;
    public String scenarioName;
    public String syncHostPropertiesUrl;
    public String labLinkPropertiesUrl;
    public String redisIpAddress;
    public int redisPort;
    public int msTimeInterval;

    public RedisOpalConfig(String configFileName) {
        String rawConfig = this.getRawConfigString(configFileName);
        rawConfig = rawConfig.replaceAll("#.*#", "");
        int still = rawConfig.length() - rawConfig.replace("#", "").length();
        if (still > 0) {
            throw new IllegalArgumentException(String.format("Config file contains at least %1$d line(s) with incorrectlystarted/terminated comments: %2$s", still, configFileName));
        }
        try {
            JSONParser jsonParser = new JSONParser();
            JSONObject conf = (JSONObject)jsonParser.parse(rawConfig);
            this.parseConfig(conf);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(String.format("Invalid configuration: %1$s", configFileName));
        }
    }

    private void parseConfig(JSONObject config) {
        if (config.containsKey((Object)"cmdsFile")) {
            this.commands = this.readFile((String)config.get((Object)"cmdsFile"));
        } else if (config.containsKey((Object)"commands")) {
            this.commands = this.readJsonArray((JSONArray)config.get((Object)"commands"));
        }
        if (config.containsKey((Object)"measFile")) {
            this.measurements = this.readFile((String)config.get((Object)"measFile"));
        } else if (config.containsKey((Object)"measurements")) {
            this.measurements = this.readJsonArray((JSONArray)config.get((Object)"measurements"));
        }
        this.groupName = (String)config.get((Object)"groupName");
        this.clientName = (String)config.get((Object)"clientName");
        this.scenarioName = (String)config.get((Object)"scenarioName");
        this.syncHostPropertiesUrl = (String)config.get((Object)"syncHostPropertiesUrl");
        this.labLinkPropertiesUrl = (String)config.get((Object)"labLinkPropertiesUrl");
        this.redisIpAddress = (String)config.get((Object)"redisIP");
        this.redisPort = Integer.parseInt((String)config.get((Object)"redisPort"));
        this.msTimeInterval = config.containsKey((Object)"msTimeInterval") ? (Integer)config.get((Object)"msTimeInterval") : 5000;
    }

    private ArrayList<String> readFile(String fileName) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            BufferedReader fileReader = new BufferedReader(new FileReader(fileName));
            while ((line = fileReader.readLine()) != null) {
                list.add(line);
            }
            fileReader.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException(String.format("Invalid configuration input file: %1$s", fileName));
        }
        return list;
    }

    private ArrayList<String> readJsonArray(JSONArray array) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator arrayIter = array.iterator();
        while (arrayIter.hasNext()) {
            list.add((String)arrayIter.next());
        }
        return list;
    }

    private String getRawConfigString(String configFileName) {
        try {
            if (this.isLocalFilePath(configFileName)) {
                return Files.readString(Path.of(configFileName, new String[0]));
            }
            URL fullConfigUrl = new URL(Utility.parseWithEnvironmentVariable((String)configFileName));
            Scanner scanner = new Scanner(fullConfigUrl.openStream());
            return scanner.useDelimiter("\\Z").next();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        throw new IllegalArgumentException(String.format("Invalid configuration: %1$s", configFileName));
    }

    private boolean isLocalFilePath(String configFileName) {
        try {
            return Files.exists(Path.of(configFileName, new String[0]), new LinkOption[0]);
        }
        catch (InvalidPathException ex) {
            return false;
        }
    }
}

