/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.lablink.clients.redisclient;

import at.ac.ait.lablink.clients.redisclient.RedisClient;
import at.ac.ait.lablink.clients.redisclient.RedisOpalConfig;
import at.ac.ait.lablink.core.client.ex.ClientNotReadyException;
import at.ac.ait.lablink.core.client.ex.CommInterfaceNotSupportedException;
import at.ac.ait.lablink.core.client.ex.DataTypeNotSupportedException;
import at.ac.ait.lablink.core.client.ex.NoServicesInClientLogicException;
import at.ac.ait.lablink.core.client.ex.NoSuchCommInterfaceException;
import at.ac.ait.lablink.core.client.ex.ServiceIsNotRegisteredWithClientException;
import at.ac.ait.lablink.core.client.ex.ServiceTypeDoesNotMatchClientType;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RedisOpalClient {
    private static final String DEFAULT_JSON_CONFIG_FILE = "opalconfig.json";
    private static final String USAGE = "[-c <url> | -h ]";
    private static final String HEADER = "Redis Client for the ROADB (Opal data layer) -  v0.0.1";
    private static final String FOOTER = "For more information, check https://github.com/AIT-Lablink";
    private static final Logger logger = LogManager.getLogger((String)"RedisClientOpal");

    private static void printUsage(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(80);
        helpFormatter.printHelp(USAGE, HEADER, options, FOOTER);
    }

    public static void main(String[] args) throws ClientNotReadyException, CommInterfaceNotSupportedException, DataTypeNotSupportedException, NoServicesInClientLogicException, NoSuchCommInterfaceException, ServiceIsNotRegisteredWithClientException, ServiceTypeDoesNotMatchClientType, ConfigurationException, ParseException, FileNotFoundException, IOException {
        String row;
        String signal;
        Options cliOptions = new Options();
        BasicParser parser = new BasicParser();
        cliOptions.addOption("h", "help", false, "print usage information");
        cliOptions.addOption("c", "config file", true, "URL to configuration file (opalconfig.json)");
        CommandLine commandLine = parser.parse(cliOptions, args);
        String configFile = DEFAULT_JSON_CONFIG_FILE;
        if (commandLine.hasOption("c")) {
            configFile = commandLine.getOptionValue("c");
        }
        if (commandLine.hasOption("h")) {
            RedisOpalClient.printUsage(cliOptions);
            System.exit(0);
        }
        RedisOpalConfig config = new RedisOpalConfig(configFile);
        String clientDesc = HEADER;
        RedisClient redisClient = new RedisClient(config.redisIpAddress, config.redisPort, config.scenarioName, config.groupName, config.clientName, clientDesc, config.labLinkPropertiesUrl, config.syncHostPropertiesUrl);
        BufferedReader csvReader = new BufferedReader(new FileReader(config.measFile));
        while ((signal = csvReader.readLine()) != null) {
            redisClient.addRedisKeyAsSensor(signal, 5000);
        }
        csvReader.close();
        csvReader = new BufferedReader(new FileReader(config.cmdsFile));
        while ((row = csvReader.readLine()) != null) {
            String[] data = row.split(",");
            signal = data[0];
            redisClient.addRedisKeyAsActuator(signal);
        }
        csvReader.close();
        redisClient.start();
    }
}

