/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.lablink.clients.redisclient;

import at.ac.ait.lablink.core.client.ci.mqtt.impl.MqttCommInterfaceUtility;
import at.ac.ait.lablink.core.client.ex.ClientNotReadyException;
import at.ac.ait.lablink.core.client.ex.CommInterfaceNotSupportedException;
import at.ac.ait.lablink.core.client.ex.DataTypeNotSupportedException;
import at.ac.ait.lablink.core.client.ex.NoServicesInClientLogicException;
import at.ac.ait.lablink.core.client.ex.NoSuchCommInterfaceException;
import at.ac.ait.lablink.core.client.ex.ServiceIsNotRegisteredWithClientException;
import at.ac.ait.lablink.core.client.ex.ServiceTypeDoesNotMatchClientType;
import at.ac.ait.lablink.core.client.impl.LlClient;
import at.ac.ait.lablink.core.service.IImplementedService;
import at.ac.ait.lablink.core.service.IServiceStateChangeNotifier;
import at.ac.ait.lablink.core.service.LlService;
import at.ac.ait.lablink.core.service.LlServiceDouble;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisClient {
    private static final Logger logger = LogManager.getLogger((String)"RedisClient");
    private static JedisPool jedisPool = null;
    private String scenarioName;
    private String groupName;
    private String clientName;
    private String clientDesc;
    private String llprop;
    private String llsync;
    private boolean giveShell = true;
    private boolean isPseudo = false;
    private List<SensorConf> sensorList = new ArrayList<SensorConf>();
    private LlClient client;

    public RedisClient() {
    }

    public RedisClient(String redisIpAddress, int redisPort, String scenarioName, String groupName, String clientName, String clientDesc, String llprop, String llsync) throws ClientNotReadyException, CommInterfaceNotSupportedException, DataTypeNotSupportedException, NoServicesInClientLogicException, NoSuchCommInterfaceException, ServiceIsNotRegisteredWithClientException, ServiceTypeDoesNotMatchClientType, ConfigurationException {
        jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), redisIpAddress, redisPort);
        this.scenarioName = scenarioName;
        this.groupName = groupName;
        this.clientName = clientName;
        this.clientDesc = clientDesc;
        this.llprop = llprop;
        this.llsync = llsync;
        this.client = new LlClient(clientName, "LL_HOST_MQTT_IMPL", this.giveShell, this.isPseudo, new String[0]);
        MqttCommInterfaceUtility.addClientProperties((LlClient)this.client, (String)clientDesc, (String)scenarioName, (String)groupName, (String)clientName, (String)llprop, (String)llsync, null);
    }

    public void addRedisKeyAsSensor(String key, int msTimeInterval) throws ServiceTypeDoesNotMatchClientType {
        String sensorName = key;
        String sensorDesc = "Sends values from " + key + " every " + msTimeInterval + " ms.";
        String sensorUnit = "";
        RedisSensor sensorService = new RedisSensor();
        sensorService.setName(sensorName);
        MqttCommInterfaceUtility.addDataPointProperties((LlService)sensorService, (String)sensorName, (String)sensorDesc, (String)sensorName, (String)sensorUnit);
        sensorService.addStateChangeNotifier(new RedisClientNotifier());
        this.client.addService((LlService)sensorService);
        this.sensorList.add(new SensorConf(sensorName, msTimeInterval));
    }

    public void addRedisKeyAsActuator(String key) throws ServiceTypeDoesNotMatchClientType {
        String actuatorName = key;
        String actuatorDesc = "Sends values to " + key + ".";
        String actuatorUnit = "none";
        RedisActuator actuatorService = new RedisActuator();
        actuatorService.setName(actuatorName);
        MqttCommInterfaceUtility.addDataPointProperties((LlService)actuatorService, (String)actuatorName, (String)actuatorDesc, (String)actuatorName, (String)actuatorUnit);
        actuatorService.addStateChangeNotifier(new RedisClientNotifier());
        this.client.addService((LlService)actuatorService);
    }

    public void start() throws ServiceTypeDoesNotMatchClientType, ClientNotReadyException, NoSuchCommInterfaceException, ConfigurationException, NoServicesInClientLogicException, DataTypeNotSupportedException {
        this.client.create();
        this.client.init();
        for (int i = 0; i < this.sensorList.size(); ++i) {
            Timer timer = new Timer();
            timer.schedule((TimerTask)new RedisReader(this.client, this.sensorList.get((int)i).name), 0L, (long)this.sensorList.get((int)i).timeInterval);
        }
        this.client.start();
    }

    class RedisSensor
    extends LlServiceDouble {
        RedisSensor() {
        }

        public Double get() {
            return (Double)this.getCurState();
        }

        public boolean set(Double newVal) {
            logger.info("{}: set new value to '{}'", (Object)this.getName(), (Object)newVal);
            this.setCurState(newVal);
            return true;
        }
    }

    class RedisClientNotifier
    implements IServiceStateChangeNotifier<LlService, Double> {
        RedisClientNotifier() {
        }

        public void stateChanged(LlService service, Double oldVal, Double newVal) {
            logger.info("{}: notifier -> state Changed from '{}' to '{}'", (Object)service.getName(), (Object)oldVal, (Object)newVal);
        }
    }

    private class SensorConf {
        String name;
        int timeInterval;

        SensorConf(String name, int timeInterval) {
            this.name = name;
            this.timeInterval = timeInterval;
        }
    }

    class RedisActuator
    extends LlServiceDouble {
        RedisActuator() {
        }

        public Double get() {
            return (Double)this.getCurState();
        }

        public boolean set(Double newVal) {
            logger.info("{}: set new value to '{}'", (Object)this.getName(), (Object)newVal);
            try (Jedis jedis = jedisPool.getResource();){
                jedis.set(this.getName(), newVal.toString());
                Double redisVal = Double.parseDouble(jedis.get(this.getName()));
                if (redisVal == newVal) {
                    this.setCurState(newVal);
                }
            }
            return true;
        }
    }

    private static class RedisReader
    extends TimerTask {
        private LlClient client;
        private IImplementedService<Double> service;
        private String sensorName;

        public RedisReader(LlClient client, String sensorName) {
            this.client = client;
            this.sensorName = sensorName;
            this.service = (IImplementedService)client.getImplementedServices().get(sensorName);
        }

        @Override
        public void run() {
            try (Jedis jedis = jedisPool.getResource();){
                Double value = Double.parseDouble(jedis.get(this.sensorName));
                this.service.setValue((Object)value);
            }
        }
    }
}

