/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.bridge.IMessage;
import org.aspectj.util.FileUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.CrosscuttingMembers;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ConcreteCflowPointcut;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.Pointcut;

public class CflowPointcut
extends Pointcut {
    private Pointcut entry;
    boolean isBelow;
    private int[] freeVars;
    private static Hashtable cflowFields = new Hashtable();
    private static Hashtable cflowBelowFields = new Hashtable();
    public static final ResolvedPointcutDefinition CFLOW_MARKER = new ResolvedPointcutDefinition(null, 0, null, UnresolvedType.NONE, Pointcut.makeMatchesNothing(Pointcut.RESOLVED));

    public CflowPointcut(Pointcut entry, boolean isBelow, int[] freeVars) {
        this.entry = entry;
        this.isBelow = isBelow;
        this.freeVars = freeVars;
        this.pointcutKind = (byte)10;
    }

    public boolean isCflowBelow() {
        return this.isBelow;
    }

    public Set couldMatchKinds() {
        return Shadow.ALL_SHADOW_KINDS;
    }

    public Pointcut getEntry() {
        return this.entry;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return FuzzyBoolean.MAYBE;
    }

    protected FuzzyBoolean matchInternal(Shadow shadow) {
        return FuzzyBoolean.MAYBE;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(10);
        this.entry.write(s);
        s.writeBoolean(this.isBelow);
        FileUtil.writeIntArray(this.freeVars, s);
        this.writeLocation(s);
    }

    public static Pointcut read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        CflowPointcut ret = new CflowPointcut(Pointcut.read(s, context), s.readBoolean(), FileUtil.readIntArray(s));
        ret.readLocation(context, s);
        return ret;
    }

    public Pointcut parameterizeWith(Map typeVariableMap) {
        CflowPointcut ret = new CflowPointcut(this.entry.parameterizeWith(typeVariableMap), this.isBelow, this.freeVars);
        ret.copyLocationFrom(this);
        return ret;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        if (bindings == null) {
            this.entry.resolveBindings(scope, null);
            this.entry.state = Pointcut.RESOLVED;
            this.freeVars = new int[0];
        } else {
            Bindings entryBindings = new Bindings(bindings.size());
            this.entry.resolveBindings(scope, entryBindings);
            this.entry.state = Pointcut.RESOLVED;
            this.freeVars = entryBindings.getUsedFormals();
            bindings.mergeIn(entryBindings, scope);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof CflowPointcut)) {
            return false;
        }
        CflowPointcut o = (CflowPointcut)other;
        return o.entry.equals(this.entry) && o.isBelow == this.isBelow;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.entry.hashCode();
        result = 37 * result + (this.isBelow ? 0 : 1);
        return result;
    }

    public String toString() {
        return "cflow" + (this.isBelow ? "below" : "") + "(" + this.entry + ")";
    }

    protected Test findResidueInternal(Shadow shadow, ExposedState state) {
        throw new RuntimeException("unimplemented - did concretization fail?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointcut concretize1(ResolvedType inAspect, ResolvedType declaringType, IntMap bindings) {
        Pointcut concreteEntry;
        if (this.isDeclare(bindings.getEnclosingAdvice())) {
            inAspect.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("cflowInDeclare", this.isBelow ? "below" : ""), bindings.getEnclosingAdvice().getSourceLocation(), null);
            return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
        }
        IntMap entryBindings = new IntMap();
        if (this.freeVars != null) {
            int len = this.freeVars.length;
            for (int i = 0; i < len; ++i) {
                int freeVar = this.freeVars[i];
                entryBindings.put(freeVar, i);
            }
        }
        entryBindings.copyContext(bindings);
        World world = inAspect.getWorld();
        ResolvedType concreteAspect = bindings.getConcreteAspect();
        CrosscuttingMembers xcut = concreteAspect.crosscuttingMembers;
        Collection previousCflowEntries = xcut.getCflowEntries();
        entryBindings.pushEnclosingDefinition(CFLOW_MARKER);
        try {
            concreteEntry = this.entry.concretize(inAspect, declaringType, entryBindings);
        }
        finally {
            entryBindings.popEnclosingDefinitition();
        }
        ArrayList innerCflowEntries = new ArrayList(xcut.getCflowEntries());
        innerCflowEntries.removeAll(previousCflowEntries);
        Object field = this.getCflowfield(concreteEntry, concreteAspect);
        if (this.freeVars == null || this.freeVars.length == 0) {
            ResolvedMember localCflowField = null;
            if (field != null) {
                localCflowField = (ResolvedMember)field;
            } else {
                localCflowField = new ResolvedMemberImpl(Member.FIELD, concreteAspect, 25, NameMangler.cflowCounter(xcut), UnresolvedType.forName("org.aspectj.runtime.internal.CFlowCounter").getSignature());
                concreteAspect.crosscuttingMembers.addTypeMunger(world.makeCflowCounterFieldAdder(localCflowField));
                concreteAspect.crosscuttingMembers.addConcreteShadowMunger(Advice.makeCflowEntry(world, concreteEntry, this.isBelow, localCflowField, this.freeVars == null ? 0 : this.freeVars.length, innerCflowEntries, inAspect));
                this.putCflowfield(concreteEntry, concreteAspect, localCflowField);
            }
            ConcreteCflowPointcut ret = new ConcreteCflowPointcut(localCflowField, null, true);
            ret.copyLocationFrom(this);
            return ret;
        }
        ArrayList<ConcreteCflowPointcut.Slot> slots = new ArrayList<ConcreteCflowPointcut.Slot>();
        int len = this.freeVars.length;
        for (int i = 0; i < len; ++i) {
            int freeVar = this.freeVars[i];
            if (!bindings.hasKey(freeVar)) continue;
            int formalIndex = bindings.get(freeVar);
            ResolvedPointcutDefinition enclosingDef = bindings.peekEnclosingDefinition();
            ResolvedType formalType = null;
            formalType = enclosingDef != null && enclosingDef.getParameterTypes().length > 0 ? enclosingDef.getParameterTypes()[freeVar].resolve(world) : bindings.getAdviceSignature().getParameterTypes()[formalIndex].resolve(world);
            ConcreteCflowPointcut.Slot slot = new ConcreteCflowPointcut.Slot(formalIndex, formalType, i);
            slots.add(slot);
        }
        ResolvedMember localCflowField = null;
        if (field != null) {
            localCflowField = (ResolvedMember)field;
        } else {
            localCflowField = new ResolvedMemberImpl(Member.FIELD, concreteAspect, 25, NameMangler.cflowStack(xcut), UnresolvedType.forName("org.aspectj.runtime.internal.CFlowStack").getSignature());
            concreteAspect.crosscuttingMembers.addConcreteShadowMunger(Advice.makeCflowEntry(world, concreteEntry, this.isBelow, localCflowField, this.freeVars.length, innerCflowEntries, inAspect));
            concreteAspect.crosscuttingMembers.addTypeMunger(world.makeCflowStackFieldAdder(localCflowField));
            this.putCflowfield(concreteEntry, concreteAspect, localCflowField);
        }
        ConcreteCflowPointcut ret = new ConcreteCflowPointcut(localCflowField, slots, false);
        ret.copyLocationFrom(this);
        return ret;
    }

    public static void clearCaches() {
        cflowFields.clear();
        cflowBelowFields.clear();
    }

    private String getKey(Pointcut p, ResolvedType a) {
        StringBuffer sb = new StringBuffer();
        sb.append(a.getName());
        sb.append("::");
        sb.append(p.toString());
        return sb.toString();
    }

    private Object getCflowfield(Pointcut pcutkey, ResolvedType concreteAspect) {
        String key = this.getKey(pcutkey, concreteAspect);
        Object o = null;
        o = this.isBelow ? cflowBelowFields.get(key) : cflowFields.get(key);
        return o;
    }

    private void putCflowfield(Pointcut pcutkey, ResolvedType concreteAspect, Object o) {
        String key = this.getKey(pcutkey, concreteAspect);
        if (this.isBelow) {
            cflowBelowFields.put(key, o);
        } else {
            cflowFields.put(key, o);
        }
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public static void clearCaches(ResolvedType aspectType) {
        String key = aspectType.getName() + "::";
        CflowPointcut.wipeKeys(key, cflowFields);
        CflowPointcut.wipeKeys(key, cflowBelowFields);
    }

    private static void wipeKeys(String keyPrefix, Hashtable ht) {
        Enumeration keys = ht.keys();
        ArrayList<String> forRemoval = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            String s = (String)keys.nextElement();
            if (!s.startsWith(keyPrefix)) continue;
            forRemoval.add(s);
        }
        Iterator iter = forRemoval.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            ht.remove(element);
        }
    }
}

