/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.GenericSignatureParser;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.AtAjAttributes;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelGenericSignatureToTypeXConverter;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.Utility;

final class BcelMethod
extends ResolvedMemberImpl {
    private Method method;
    private boolean isAjSynthetic;
    private ShadowMunger associatedShadowMunger;
    private ResolvedPointcutDefinition preResolvedPointcut;
    private AnnotationX[] annotations = null;
    private AjAttribute.EffectiveSignatureAttribute effectiveSignature;
    private AjAttribute.MethodDeclarationLineNumberAttribute declarationLineNumber;
    private World world;
    private BcelObjectType bcelObjectType;
    private boolean canBeParameterized = false;
    private boolean unpackedGenericSignature = false;
    private UnresolvedType genericReturnType = null;
    private UnresolvedType[] genericParameterTypes = null;

    BcelMethod(BcelObjectType declaringType, Method method) {
        super(method.getName().equals("<init>") ? Member.CONSTRUCTOR : (method.getName().equals("<clinit>") ? Member.STATIC_INITIALIZATION : Member.METHOD), declaringType.getResolvedTypeX(), declaringType.isInterface() ? method.getAccessFlags() | 0x200 : method.getAccessFlags(), method.getName(), method.getSignature());
        this.method = method;
        this.sourceContext = declaringType.getResolvedTypeX().getSourceContext();
        this.world = declaringType.getResolvedTypeX().getWorld();
        this.bcelObjectType = declaringType;
        this.unpackJavaAttributes();
        this.unpackAjAttributes(this.world);
    }

    private void unpackJavaAttributes() {
        ExceptionTable exnTable = this.method.getExceptionTable();
        this.checkedExceptions = exnTable == null ? UnresolvedType.NONE : UnresolvedType.forNames(exnTable.getExceptionNames());
        LocalVariableTable varTable = this.method.getLocalVariableTable();
        int len = this.getArity();
        if (varTable == null) {
            this.parameterNames = Utility.makeArgNames(len);
        } else {
            UnresolvedType[] paramTypes = this.getParameterTypes();
            String[] paramNames = new String[len];
            int index = this.isStatic() ? 0 : 1;
            for (int i = 0; i < len; ++i) {
                LocalVariable lv = varTable.getLocalVariable(index);
                paramNames[i] = lv == null ? "arg" + i : lv.getName();
                index += paramTypes[i].getSize();
            }
            this.parameterNames = paramNames;
        }
    }

    private void unpackAjAttributes(World world) {
        this.associatedShadowMunger = null;
        List as = BcelAttributes.readAjAttributes(this.getDeclaringType().getClassName(), this.method.getAttributes(), this.getSourceContext(world), world.getMessageHandler(), this.bcelObjectType.getWeaverVersionAttribute());
        this.processAttributes(world, as);
        as = AtAjAttributes.readAj5MethodAttributes(this.method, this, world.resolve(this.getDeclaringType()), this.preResolvedPointcut, this.getSourceContext(world), world.getMessageHandler());
        this.processAttributes(world, as);
    }

    private void processAttributes(World world, List as) {
        Iterator iter = as.iterator();
        while (iter.hasNext()) {
            AjAttribute a = (AjAttribute)iter.next();
            if (a instanceof AjAttribute.MethodDeclarationLineNumberAttribute) {
                this.declarationLineNumber = (AjAttribute.MethodDeclarationLineNumberAttribute)a;
                continue;
            }
            if (a instanceof AjAttribute.AdviceAttribute) {
                this.associatedShadowMunger = ((AjAttribute.AdviceAttribute)a).reify(this, world);
                continue;
            }
            if (a instanceof AjAttribute.AjSynthetic) {
                this.isAjSynthetic = true;
                continue;
            }
            if (a instanceof AjAttribute.EffectiveSignatureAttribute) {
                this.effectiveSignature = (AjAttribute.EffectiveSignatureAttribute)a;
                continue;
            }
            if (a instanceof AjAttribute.PointcutDeclarationAttribute) {
                this.preResolvedPointcut = ((AjAttribute.PointcutDeclarationAttribute)a).reify();
                continue;
            }
            throw new BCException("weird method attribute " + a);
        }
    }

    public boolean isAjSynthetic() {
        return this.isAjSynthetic;
    }

    public ShadowMunger getAssociatedShadowMunger() {
        return this.associatedShadowMunger;
    }

    public AjAttribute.EffectiveSignatureAttribute getEffectiveSignature() {
        return this.effectiveSignature;
    }

    public boolean hasDeclarationLineNumberInfo() {
        return this.declarationLineNumber != null;
    }

    public int getDeclarationLineNumber() {
        if (this.declarationLineNumber != null) {
            return this.declarationLineNumber.getLineNumber();
        }
        return -1;
    }

    public int getDeclarationOffset() {
        if (this.declarationLineNumber != null) {
            return this.declarationLineNumber.getOffset();
        }
        return -1;
    }

    public ISourceLocation getSourceLocation() {
        ISourceLocation ret = super.getSourceLocation();
        if ((ret == null || ret.getLine() == 0) && this.hasDeclarationLineNumberInfo()) {
            ISourceContext isc = this.getSourceContext();
            ret = isc != null ? isc.makeSourceLocation(this.getDeclarationLineNumber(), this.getDeclarationOffset()) : new SourceLocation(null, this.getDeclarationLineNumber());
        }
        return ret;
    }

    public Member.Kind getKind() {
        if (this.associatedShadowMunger != null) {
            return Member.ADVICE;
        }
        return super.getKind();
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        this.ensureAnnotationTypesRetrieved();
        Iterator iter = this.annotationTypes.iterator();
        while (iter.hasNext()) {
            ResolvedType aType = (ResolvedType)iter.next();
            if (!aType.equals(ofType)) continue;
            return true;
        }
        return false;
    }

    public AnnotationX[] getAnnotations() {
        this.ensureAnnotationTypesRetrieved();
        return this.annotations;
    }

    public ResolvedType[] getAnnotationTypes() {
        this.ensureAnnotationTypesRetrieved();
        ResolvedType[] ret = new ResolvedType[this.annotationTypes.size()];
        this.annotationTypes.toArray(ret);
        return ret;
    }

    public void addAnnotation(AnnotationX annotation) {
        this.ensureAnnotationTypesRetrieved();
        int len = this.annotations.length;
        AnnotationX[] ret = new AnnotationX[len + 1];
        System.arraycopy(this.annotations, 0, ret, 0, len);
        ret[len] = annotation;
        this.annotations = ret;
        this.annotationTypes.add(UnresolvedType.forName(annotation.getTypeName()).resolve(this.world));
        this.method.addAnnotation(annotation.getBcelAnnotation());
    }

    private void ensureAnnotationTypesRetrieved() {
        if (this.annotationTypes == null || this.method.getAnnotations().length != this.annotations.length) {
            Annotation[] annos = this.method.getAnnotations();
            this.annotationTypes = new HashSet();
            this.annotations = new AnnotationX[annos.length];
            for (int i = 0; i < annos.length; ++i) {
                Annotation annotation = annos[i];
                ResolvedType rtx = this.world.resolve(UnresolvedType.forName(annotation.getTypeName()));
                this.annotationTypes.add(rtx);
                this.annotations[i] = new AnnotationX(annotation, this.world);
            }
        }
    }

    public boolean canBeParameterized() {
        this.unpackGenericSignature();
        return this.canBeParameterized;
    }

    public UnresolvedType[] getGenericParameterTypes() {
        this.unpackGenericSignature();
        return this.genericParameterTypes;
    }

    public UnresolvedType getGenericReturnType() {
        this.unpackGenericSignature();
        return this.genericReturnType;
    }

    private void unpackGenericSignature() {
        if (this.unpackedGenericSignature) {
            return;
        }
        this.unpackedGenericSignature = true;
        String gSig = this.method.getGenericSignature();
        if (gSig != null) {
            Signature.MethodTypeSignature mSig = new GenericSignatureParser().parseAsMethodSignature(this.method.getGenericSignature());
            if (mSig.formalTypeParameters.length > 0) {
                this.canBeParameterized = true;
            }
            Signature.FormalTypeParameter[] parentFormals = this.bcelObjectType.getAllFormals();
            Signature.FormalTypeParameter[] formals = new Signature.FormalTypeParameter[parentFormals.length + mSig.formalTypeParameters.length];
            System.arraycopy(mSig.formalTypeParameters, 0, formals, 0, mSig.formalTypeParameters.length);
            System.arraycopy(parentFormals, 0, formals, mSig.formalTypeParameters.length, parentFormals.length);
            Signature.TypeSignature returnTypeSignature = mSig.returnType;
            try {
                this.genericReturnType = BcelGenericSignatureToTypeXConverter.typeSignature2TypeX(returnTypeSignature, formals, this.world);
            }
            catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                throw new IllegalStateException("While determing the generic return type of " + this.toString() + " with generic signature " + gSig + " the following error was detected: " + e.getMessage());
            }
            Signature.TypeSignature[] paramTypeSigs = mSig.parameters;
            this.genericParameterTypes = new UnresolvedType[paramTypeSigs.length];
            for (int i = 0; i < paramTypeSigs.length; ++i) {
                try {
                    this.genericParameterTypes[i] = BcelGenericSignatureToTypeXConverter.typeSignature2TypeX(paramTypeSigs[i], formals, this.world);
                }
                catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e) {
                    throw new IllegalStateException("While determining the generic parameter types of " + this.toString() + " with generic signature " + gSig + " the following error was detected: " + e.getMessage());
                }
                if (!(paramTypeSigs[i] instanceof Signature.TypeVariableSignature)) continue;
                this.canBeParameterized = true;
            }
        } else {
            this.genericReturnType = this.getReturnType();
            this.genericParameterTypes = this.getParameterTypes();
        }
    }
}

