/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.bcel.BcelRenderer;
import org.aspectj.weaver.bcel.BcelShadow;
import org.aspectj.weaver.bcel.BcelVar;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public class BcelAdvice
extends Advice {
    private Test pointcutTest;
    private ExposedState exposedState;
    private boolean hasMatchedAtLeastOnce = false;
    private Collection thrownExceptions = null;

    public BcelAdvice(AjAttribute.AdviceAttribute attribute, Pointcut pointcut, Member signature, ResolvedType concreteAspect) {
        super(attribute, pointcut, signature);
        this.concreteAspect = concreteAspect;
    }

    public BcelAdvice(AdviceKind kind, Pointcut pointcut, Member signature, int extraArgumentFlags, int start, int end, ISourceContext sourceContext, ResolvedType concreteAspect) {
        this(new AjAttribute.AdviceAttribute(kind, pointcut, extraArgumentFlags, start, end, sourceContext), pointcut, signature, concreteAspect);
        this.thrownExceptions = Collections.EMPTY_LIST;
    }

    public ShadowMunger concretize(ResolvedType fromType, World world, PerClause clause) {
        this.suppressLintWarnings(world);
        ShadowMunger ret = super.concretize(fromType, world, clause);
        this.clearLintSuppressions(world, this.suppressedLintKinds);
        return ret;
    }

    public ShadowMunger parameterizeWith(ResolvedType declaringType, Map typeVariableMap) {
        Pointcut pc = this.getPointcut().parameterizeWith(typeVariableMap);
        BcelAdvice ret = null;
        Member adviceSignature = this.signature;
        if (this.signature instanceof ResolvedMember && this.signature.getDeclaringType().isGenericType()) {
            adviceSignature = ((ResolvedMember)this.signature).parameterizedWith(declaringType.getTypeParameters(), declaringType, declaringType.isParameterizedType());
        }
        ret = new BcelAdvice(this.attribute, pc, adviceSignature, this.concreteAspect);
        return ret;
    }

    public boolean match(Shadow shadow, World world) {
        this.suppressLintWarnings(world);
        boolean ret = super.match(shadow, world);
        this.clearLintSuppressions(world, this.suppressedLintKinds);
        return ret;
    }

    public void specializeOn(Shadow shadow) {
        if (this.getKind() == AdviceKind.Around) {
            ((BcelShadow)shadow).initializeForAroundClosure();
        }
        if (this.getKind() == null) {
            this.exposedState = new ExposedState(0);
            return;
        }
        if (this.getKind().isPerEntry()) {
            this.exposedState = new ExposedState(0);
        } else if (this.getKind().isCflow()) {
            this.exposedState = new ExposedState(this.nFreeVars);
        } else if (this.getSignature() != null) {
            this.exposedState = new ExposedState(this.getSignature());
        } else {
            this.exposedState = new ExposedState(0);
            return;
        }
        World world = shadow.getIWorld();
        this.suppressLintWarnings(world);
        this.pointcutTest = this.getPointcut().findResidue(shadow, this.exposedState);
        this.clearLintSuppressions(world, this.suppressedLintKinds);
        if (this.getKind() == AdviceKind.PerThisEntry) {
            shadow.getThisVar();
        } else if (this.getKind() == AdviceKind.PerTargetEntry) {
            shadow.getTargetVar();
        }
        if ((this.getExtraParameterFlags() & 4) != 0) {
            ((BcelShadow)shadow).getThisJoinPointStaticPartVar();
            ((BcelShadow)shadow).getEnclosingClass().warnOnAddedStaticInitializer(shadow, this.getSourceLocation());
        }
        if ((this.getExtraParameterFlags() & 2) != 0) {
            boolean hasGuardTest = this.pointcutTest != Literal.TRUE && this.getKind() != AdviceKind.Around;
            boolean isAround = this.getKind() == AdviceKind.Around;
            ((BcelShadow)shadow).requireThisJoinPoint(hasGuardTest, isAround);
            ((BcelShadow)shadow).getEnclosingClass().warnOnAddedStaticInitializer(shadow, this.getSourceLocation());
            if (!hasGuardTest && world.getLint().multipleAdviceStoppingLazyTjp.isEnabled()) {
                ((BcelShadow)shadow).addAdvicePreventingLazyTjp(this);
            }
            if (!isAround && !hasGuardTest && world.getLint().noGuardForLazyTjp.isEnabled()) {
                world.getLint().noGuardForLazyTjp.signal(new String[]{shadow.toString()}, this.getSourceLocation(), new ISourceLocation[]{((BcelShadow)shadow).getSourceLocation()});
            }
        }
        if ((this.getExtraParameterFlags() & 8) != 0) {
            ((BcelShadow)shadow).getThisEnclosingJoinPointStaticPartVar();
            ((BcelShadow)shadow).getEnclosingClass().warnOnAddedStaticInitializer(shadow, this.getSourceLocation());
        }
    }

    private boolean canInline(Shadow s) {
        if (this.attribute.isProceedInInners()) {
            return false;
        }
        if (this.concreteAspect == null || this.concreteAspect.isMissing()) {
            return false;
        }
        if (this.concreteAspect.getWorld().isXnoInline()) {
            return false;
        }
        return BcelWorld.getBcelObjectType(this.concreteAspect).getLazyClassGen().isWoven();
    }

    public void implementOn(Shadow s) {
        this.hasMatchedAtLeastOnce = true;
        BcelShadow shadow = (BcelShadow)s;
        if (this.getKind() == AdviceKind.Before) {
            shadow.weaveBefore(this);
        } else if (this.getKind() == AdviceKind.AfterReturning) {
            shadow.weaveAfterReturning(this);
        } else if (this.getKind() == AdviceKind.AfterThrowing) {
            UnresolvedType catchType = this.hasExtraParameter() ? this.getExtraParameterType() : UnresolvedType.THROWABLE;
            shadow.weaveAfterThrowing(this, catchType);
        } else if (this.getKind() == AdviceKind.After) {
            shadow.weaveAfter(this);
        } else if (this.getKind() == AdviceKind.Around) {
            if (!this.canInline(s)) {
                shadow.weaveAroundClosure(this, this.hasDynamicTests());
            } else {
                shadow.weaveAroundInline(this, this.hasDynamicTests());
            }
        } else if (this.getKind() == AdviceKind.InterInitializer) {
            shadow.weaveAfterReturning(this);
        } else if (this.getKind().isCflow()) {
            shadow.weaveCflowEntry(this, this.getSignature());
        } else if (this.getKind() == AdviceKind.PerThisEntry) {
            shadow.weavePerObjectEntry(this, (BcelVar)shadow.getThisVar());
        } else if (this.getKind() == AdviceKind.PerTargetEntry) {
            shadow.weavePerObjectEntry(this, (BcelVar)shadow.getTargetVar());
        } else if (this.getKind() == AdviceKind.Softener) {
            shadow.weaveSoftener(this, ((ExactTypePattern)this.exceptionType).getType());
        } else if (this.getKind() == AdviceKind.PerTypeWithinEntry) {
            shadow.weavePerTypeWithinAspectInitialization(this, shadow.getEnclosingType());
        } else {
            throw new BCException("unimplemented kind: " + this.getKind());
        }
    }

    private Collection collectCheckedExceptions(UnresolvedType[] excs) {
        if (excs == null || excs.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ResolvedType> ret = new ArrayList<ResolvedType>();
        World world = this.concreteAspect.getWorld();
        ResolvedType runtimeException = world.getCoreType(UnresolvedType.RUNTIME_EXCEPTION);
        ResolvedType error = world.getCoreType(UnresolvedType.ERROR);
        int len = excs.length;
        for (int i = 0; i < len; ++i) {
            ResolvedType t = world.resolve(excs[i], true);
            if (t.isMissing()) {
                world.getLint().cantFindType.signal(WeaverMessages.format("cftExceptionType", excs[i].getName()), this.getSourceLocation());
            }
            if (runtimeException.isAssignableFrom(t) || error.isAssignableFrom(t)) continue;
            ret.add(t);
        }
        return ret;
    }

    public Collection getThrownExceptions() {
        if (this.thrownExceptions == null) {
            World world;
            ResolvedMember m;
            this.thrownExceptions = this.concreteAspect != null && this.concreteAspect.getWorld() != null && (this.getKind().isAfter() || this.getKind() == AdviceKind.Before || this.getKind() == AdviceKind.Around) ? ((m = (world = this.concreteAspect.getWorld()).resolve(this.signature)) == null ? Collections.EMPTY_LIST : this.collectCheckedExceptions(m.getExceptions())) : Collections.EMPTY_LIST;
        }
        return this.thrownExceptions;
    }

    public boolean mustCheckExceptions() {
        if (this.getConcreteAspect() == null) {
            return true;
        }
        return !this.getConcreteAspect().isAnnotationStyleAspect();
    }

    public boolean hasDynamicTests() {
        return this.pointcutTest != null && this.pointcutTest != Literal.TRUE;
    }

    InstructionList getAdviceInstructions(BcelShadow s, BcelVar extraArgVar, InstructionHandle ifNoAdvice) {
        UnresolvedType extraParameterType;
        BcelShadow shadow = s;
        InstructionFactory fact = shadow.getFactory();
        BcelWorld world = shadow.getWorld();
        InstructionList il = new InstructionList();
        if (this.hasExtraParameter() && this.getKind() == AdviceKind.AfterReturning && !(extraParameterType = this.getExtraParameterType()).equals(UnresolvedType.OBJECT) && !extraParameterType.isPrimitiveType()) {
            il.append(BcelRenderer.renderTest(fact, world, Test.makeInstanceof(extraArgVar, this.getExtraParameterType().resolve(world)), null, ifNoAdvice, null));
        }
        il.append(this.getAdviceArgSetup(shadow, extraArgVar, null));
        il.append(this.getNonTestAdviceInstructions(shadow));
        InstructionHandle ifYesAdvice = il.getStart();
        il.insert(this.getTestInstructions(shadow, ifYesAdvice, ifNoAdvice, ifYesAdvice));
        return il;
    }

    public InstructionList getAdviceArgSetup(BcelShadow shadow, BcelVar extraVar, InstructionList closureInstantiation) {
        InstructionFactory fact = shadow.getFactory();
        BcelWorld world = shadow.getWorld();
        InstructionList il = new InstructionList();
        if (this.exposedState.getAspectInstance() != null) {
            il.append(BcelRenderer.renderExpr(fact, world, this.exposedState.getAspectInstance()));
        }
        boolean isAnnotationStyleAspect = this.getConcreteAspect() != null && this.getConcreteAspect().isAnnotationStyleAspect();
        boolean previousIsClosure = false;
        int len = this.exposedState.size();
        for (int i = 0; i < len; ++i) {
            if (this.exposedState.isErroneousVar(i)) continue;
            BcelVar v = (BcelVar)this.exposedState.get(i);
            if (v == null) {
                if (!isAnnotationStyleAspect) continue;
                if ("Lorg/aspectj/lang/ProceedingJoinPoint;".equals(this.getSignature().getParameterTypes()[i].getSignature())) {
                    if (this.getKind() != AdviceKind.Around) {
                        previousIsClosure = false;
                        this.getConcreteAspect().getWorld().getMessageHandler().handleMessage(new Message("use of ProceedingJoinPoint is allowed only on around advice (arg " + i + " in " + this.toString() + ")", this.getSourceLocation(), true));
                        il.append(InstructionConstants.ACONST_NULL);
                        continue;
                    }
                    if (previousIsClosure) {
                        il.append(InstructionConstants.DUP);
                        continue;
                    }
                    previousIsClosure = true;
                    il.append(closureInstantiation.copy());
                    continue;
                }
                if ("Lorg/aspectj/lang/JoinPoint$StaticPart;".equals(this.getSignature().getParameterTypes()[i].getSignature())) {
                    previousIsClosure = false;
                    if ((this.getExtraParameterFlags() & 4) == 0) continue;
                    shadow.getThisJoinPointStaticPartBcelVar().appendLoad(il, fact);
                    continue;
                }
                if ("Lorg/aspectj/lang/JoinPoint;".equals(this.getSignature().getParameterTypes()[i].getSignature())) {
                    previousIsClosure = false;
                    if ((this.getExtraParameterFlags() & 2) == 0) continue;
                    il.append(shadow.loadThisJoinPoint());
                    continue;
                }
                if ("Lorg/aspectj/lang/JoinPoint$EnclosingStaticPart;".equals(this.getSignature().getParameterTypes()[i].getSignature())) {
                    previousIsClosure = false;
                    if ((this.getExtraParameterFlags() & 8) == 0) continue;
                    shadow.getThisEnclosingJoinPointStaticPartBcelVar().appendLoad(il, fact);
                    continue;
                }
                if (this.hasExtraParameter()) {
                    previousIsClosure = false;
                    if (extraVar == null) continue;
                    extraVar.appendLoadAndConvert(il, fact, this.getExtraParameterType().resolve(world));
                    continue;
                }
                previousIsClosure = false;
                this.getConcreteAspect().getWorld().getMessageHandler().handleMessage(new Message("use of ProceedingJoinPoint is allowed only on around advice (arg " + i + " in " + this.toString() + ")", this.getSourceLocation(), true));
                il.append(InstructionConstants.ACONST_NULL);
                continue;
            }
            UnresolvedType desiredTy = this.getBindingParameterTypes()[i];
            v.appendLoadAndConvert(il, fact, desiredTy.resolve(world));
        }
        if (!isAnnotationStyleAspect) {
            if (this.getKind() == AdviceKind.Around) {
                il.append(closureInstantiation);
            } else if (this.hasExtraParameter()) {
                extraVar.appendLoadAndConvert(il, fact, this.getExtraParameterType().resolve(world));
            }
            if ((this.getExtraParameterFlags() & 4) != 0) {
                shadow.getThisJoinPointStaticPartBcelVar().appendLoad(il, fact);
            }
            if ((this.getExtraParameterFlags() & 2) != 0) {
                il.append(shadow.loadThisJoinPoint());
            }
            if ((this.getExtraParameterFlags() & 8) != 0) {
                shadow.getThisEnclosingJoinPointStaticPartBcelVar().appendLoad(il, fact);
            }
        }
        return il;
    }

    public InstructionList getNonTestAdviceInstructions(BcelShadow shadow) {
        return new InstructionList(Utility.createInvoke(shadow.getFactory(), shadow.getWorld(), this.getOriginalSignature()));
    }

    public Member getOriginalSignature() {
        ResolvedMember rsig;
        Member sig = this.getSignature();
        if (sig instanceof ResolvedMember && (rsig = (ResolvedMember)sig).hasBackingGenericMember()) {
            return rsig.getBackingGenericMember();
        }
        return sig;
    }

    public InstructionList getTestInstructions(BcelShadow shadow, InstructionHandle sk, InstructionHandle fk, InstructionHandle next) {
        return BcelRenderer.renderTest(shadow.getFactory(), shadow.getWorld(), this.pointcutTest, sk, fk, next);
    }

    public int compareTo(Object other) {
        ResolvedType o_declaringAspect;
        if (!(other instanceof BcelAdvice)) {
            return 0;
        }
        BcelAdvice o = (BcelAdvice)other;
        if (this.kind.getPrecedence() != o.kind.getPrecedence()) {
            if (this.kind.getPrecedence() > o.kind.getPrecedence()) {
                return 1;
            }
            return -1;
        }
        if (this.kind.isCflow()) {
            boolean isBelow;
            boolean bl = isBelow = this.kind == AdviceKind.CflowBelowEntry;
            if (this.innerCflowEntries.contains(o)) {
                return isBelow ? 1 : -1;
            }
            if (o.innerCflowEntries.contains(this)) {
                return isBelow ? -1 : 1;
            }
            return 0;
        }
        if (this.kind.isPerEntry() || this.kind == AdviceKind.Softener) {
            return 0;
        }
        World world = this.concreteAspect.getWorld();
        int ret = this.concreteAspect.getWorld().compareByPrecedence(this.concreteAspect, o.concreteAspect);
        if (ret != 0) {
            return ret;
        }
        ResolvedType declaringAspect = this.getDeclaringAspect().resolve(world);
        if (declaringAspect == (o_declaringAspect = o.getDeclaringAspect().resolve(world))) {
            if (this.kind.isAfter() || o.kind.isAfter()) {
                return this.getStart() < o.getStart() ? -1 : 1;
            }
            return this.getStart() < o.getStart() ? 1 : -1;
        }
        if (declaringAspect.isAssignableFrom(o_declaringAspect)) {
            return -1;
        }
        if (o_declaringAspect.isAssignableFrom(declaringAspect)) {
            return 1;
        }
        return 0;
    }

    public BcelVar[] getExposedStateAsBcelVars(boolean isAround) {
        if (isAround && this.getConcreteAspect() != null && this.getConcreteAspect().isAnnotationStyleAspect()) {
            return BcelVar.NONE;
        }
        if (this.exposedState == null) {
            return BcelVar.NONE;
        }
        int len = this.exposedState.vars.length;
        BcelVar[] ret = new BcelVar[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (BcelVar)this.exposedState.vars[i];
        }
        return ret;
    }

    public boolean hasMatchedSomething() {
        return this.hasMatchedAtLeastOnce;
    }

    protected void suppressLintWarnings(World inWorld) {
        if (this.suppressedLintKinds == null) {
            this.suppressedLintKinds = this.signature instanceof BcelMethod ? Utility.getSuppressedWarnings(this.signature.getAnnotations(), inWorld.getLint()) : Collections.EMPTY_LIST;
        }
        inWorld.getLint().suppressKinds(this.suppressedLintKinds);
    }

    protected void clearLintSuppressions(World inWorld, Collection toClear) {
        inWorld.getLint().clearSuppressions(toClear);
    }
}

