/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.UnresolvedTypeVariableReferenceType;
import org.aspectj.weaver.World;

public class TypeFactory {
    public static ReferenceType createParameterizedType(ResolvedType aBaseType, UnresolvedType[] someTypeParameters, World inAWorld) {
        ResolvedType baseType = aBaseType;
        if (!aBaseType.isGenericType() && someTypeParameters != null && someTypeParameters.length > 0) {
            if (!aBaseType.isRawType()) {
                throw new IllegalStateException("Expecting raw type");
            }
            if ((baseType = baseType.getGenericType()) == null) {
                throw new IllegalStateException("Raw type does not have generic type set");
            }
        }
        ResolvedType[] resolvedParameters = inAWorld.resolve(someTypeParameters);
        ReferenceType pType = new ReferenceType(baseType, resolvedParameters, inAWorld);
        pType.setSourceContext(aBaseType.getSourceContext());
        return (ReferenceType)pType.resolve(inAWorld);
    }

    public static UnresolvedType createUnresolvedParameterizedType(String sig, String erasuresig, UnresolvedType[] arguments) {
        return new UnresolvedType(sig, erasuresig, arguments);
    }

    public static ReferenceType createRawType(ResolvedType aBaseType, World inAWorld) {
        if (aBaseType.isRawType()) {
            return (ReferenceType)aBaseType;
        }
        if (!aBaseType.isGenericType() && !aBaseType.isRawType()) {
            throw new IllegalStateException("Expecting generic type");
        }
        ReferenceType rType = new ReferenceType(aBaseType, inAWorld);
        rType.setSourceContext(aBaseType.getSourceContext());
        return (ReferenceType)rType.resolve(inAWorld);
    }

    public static UnresolvedType createTypeFromSignature(String signature) {
        if (signature.equals("@missing@")) {
            return ResolvedType.MISSING;
        }
        if (signature.startsWith("P")) {
            int startOfParams = signature.indexOf(60);
            int endOfParams = signature.lastIndexOf(62);
            String signatureErasure = "L" + signature.substring(1, startOfParams) + ";";
            UnresolvedType[] typeParams = TypeFactory.createTypeParams(signature.substring(startOfParams + 1, endOfParams));
            return new UnresolvedType(signature, signatureErasure, typeParams);
        }
        if (signature.equals("?")) {
            UnresolvedType ret = UnresolvedType.SOMETHING;
            ret.typeKind = UnresolvedType.TypeKind.WILDCARD;
            return ret;
        }
        if (signature.startsWith("+")) {
            UnresolvedType bound = UnresolvedType.forSignature(signature.substring(1));
            UnresolvedType ret = new UnresolvedType(signature);
            ret.typeKind = UnresolvedType.TypeKind.WILDCARD;
            ret.setUpperBound(bound);
            return ret;
        }
        if (signature.startsWith("-")) {
            UnresolvedType bound = UnresolvedType.forSignature(signature.substring(1));
            UnresolvedType ret = new UnresolvedType(signature);
            ret.typeKind = UnresolvedType.TypeKind.WILDCARD;
            ret.setLowerBound(bound);
            return ret;
        }
        if (signature.startsWith("T")) {
            String typeVariableName = signature.substring(1);
            if (typeVariableName.endsWith(";")) {
                typeVariableName = typeVariableName.substring(0, typeVariableName.length() - 1);
            }
            return new UnresolvedTypeVariableReferenceType(new TypeVariable(typeVariableName));
        }
        if (signature.startsWith("[")) {
            int dims = 0;
            while (signature.charAt(dims) == '[') {
                ++dims;
            }
            UnresolvedType componentType = TypeFactory.createTypeFromSignature(signature.substring(dims));
            return new UnresolvedType(signature, signature.substring(0, dims) + componentType.getErasureSignature());
        }
        if (signature.length() == 1) {
            switch (signature.charAt(0)) {
                case 'V': {
                    return ResolvedType.VOID;
                }
                case 'Z': {
                    return ResolvedType.BOOLEAN;
                }
                case 'B': {
                    return ResolvedType.BYTE;
                }
                case 'C': {
                    return ResolvedType.CHAR;
                }
                case 'D': {
                    return ResolvedType.DOUBLE;
                }
                case 'F': {
                    return ResolvedType.FLOAT;
                }
                case 'I': {
                    return ResolvedType.INT;
                }
                case 'J': {
                    return ResolvedType.LONG;
                }
                case 'S': {
                    return ResolvedType.SHORT;
                }
            }
        }
        return new UnresolvedType(signature);
    }

    private static UnresolvedType[] createTypeParams(String typeParameterSpecification) {
        String remainingToProcess = typeParameterSpecification;
        ArrayList<UnresolvedType> types = new ArrayList<UnresolvedType>();
        while (!remainingToProcess.equals("")) {
            int endOfSig = 0;
            int anglies = 0;
            boolean sigFound = false;
            block6: for (endOfSig = 0; endOfSig < remainingToProcess.length() && !sigFound; ++endOfSig) {
                char thisChar = remainingToProcess.charAt(endOfSig);
                switch (thisChar) {
                    case '<': {
                        ++anglies;
                        continue block6;
                    }
                    case '>': {
                        --anglies;
                        continue block6;
                    }
                    case ';': {
                        if (anglies != 0) continue block6;
                        sigFound = true;
                    }
                }
            }
            types.add(TypeFactory.createTypeFromSignature(remainingToProcess.substring(0, endOfSig)));
            remainingToProcess = remainingToProcess.substring(endOfSig);
        }
        UnresolvedType[] typeParams = new UnresolvedType[types.size()];
        types.toArray(typeParams);
        return typeParams;
    }
}

