/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import java.util.ArrayList;
import java.util.Iterator;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.HierarchyWalker;
import org.aspectj.asm.IProgramElement;
import org.aspectj.tools.ajdoc.Declaration;
import org.aspectj.tools.ajdoc.StructureUtil;

public class SymbolManager {
    private static SymbolManager INSTANCE = new SymbolManager();

    public static SymbolManager getDefault() {
        return INSTANCE;
    }

    public Declaration[] getDeclarations(String filename) {
        IProgramElement file = AsmManager.getDefault().getHierarchy().findElementForSourceFile(filename);
        IProgramElement node = (IProgramElement)file.getChildren().get(0);
        final ArrayList nodes = new ArrayList();
        HierarchyWalker walker = new HierarchyWalker(){

            public void preProcess(IProgramElement node) {
                IProgramElement p = node;
                if (SymbolManager.this.accept(node)) {
                    nodes.add(SymbolManager.this.buildDecl(p));
                }
            }
        };
        file.walk(walker);
        return nodes.toArray(new Declaration[nodes.size()]);
    }

    private boolean accept(IProgramElement node) {
        if (node.getKind().isType()) {
            boolean isAnonymous = StructureUtil.isAnonymous(node);
            return !node.getParent().getKind().equals(IProgramElement.Kind.METHOD) && !isAnonymous;
        }
        return !node.getKind().equals(IProgramElement.Kind.IMPORT_REFERENCE);
    }

    private Declaration buildDecl(IProgramElement node) {
        String signature = "";
        String accessibility = node.getAccessibility().toString();
        if (!accessibility.equals("package")) {
            signature = accessibility.toString() + " ";
        }
        String modifiers = "";
        if (!node.getAccessibility().equals(IProgramElement.Accessibility.PACKAGE)) {
            modifiers = modifiers + node.getAccessibility() + " ";
        }
        Iterator modIt = node.getModifiers().iterator();
        while (modIt.hasNext()) {
            modifiers = modifiers + modIt.next() + " ";
        }
        if (node.getKind().equals(IProgramElement.Kind.METHOD) || node.getKind().equals(IProgramElement.Kind.FIELD)) {
            signature = signature + node.getCorrespondingType() + " ";
        }
        if (node.getKind().equals(IProgramElement.Kind.CLASS) || node.getKind().equals(IProgramElement.Kind.METHOD)) {
            signature = signature + "class ";
        } else if (node.getKind().equals(IProgramElement.Kind.INTERFACE) || node.getKind().equals(IProgramElement.Kind.METHOD)) {
            signature = signature + "interface ";
        }
        signature = signature + node.toSignatureString();
        String name = node.getName();
        if (node.getKind().isType()) {
            name = this.genPartiallyQualifiedName(node, node.getName());
        }
        String declaringType = node.getParent().getName();
        Declaration dec = new Declaration(node.getSourceLocation().getLine(), node.getSourceLocation().getEndLine(), node.getSourceLocation().getColumn(), -1, modifiers, name, signature, "", node.getDeclaringType(), node.getKind().toString(), node.getSourceLocation().getSourceFile().getAbsolutePath(), node.getFormalComment(), node.getPackageName(), node);
        return dec;
    }

    private String genPartiallyQualifiedName(IProgramElement node, String name) {
        if (node.getParent() != null && node.getParent().getKind().isType()) {
            name = node.getParent().getName() + '.' + name;
            this.genPartiallyQualifiedName(node.getParent(), name);
        }
        return name;
    }

    public Declaration getDeclarationAtPoint(String filename, int line, int column) {
        Declaration[] declarations = this.lookupDeclarations(filename);
        return this.getDeclarationAtPoint(declarations, line, column);
    }

    public Declaration getDeclarationAtPoint(Declaration[] declarations, int line, int column) {
        if (declarations == null) {
            return null;
        }
        for (int i = 0; i < declarations.length; ++i) {
            Declaration dec1;
            Declaration[] enclosedDecs;
            Declaration dec = declarations[i];
            if (dec.getBeginLine() == line) {
                if (column == -1) {
                    return dec;
                }
                if (dec.getBeginColumn() == column) {
                    return dec;
                }
            }
            if ((enclosedDecs = dec.getDeclarations()).length == 0 || (dec1 = this.getDeclarationAtPoint(enclosedDecs, line, column)) == null) continue;
            return dec1;
        }
        return null;
    }

    private Declaration[] lookupDeclarations(String filename) {
        System.err.println("> looking up: " + filename);
        return null;
    }

    public static String translateMethodName(String methodName) {
        int firstDollar = methodName.indexOf(36);
        if (firstDollar == -1) {
            return methodName;
        }
        String baseName = methodName.substring(firstDollar);
        if (methodName.indexOf("ajc") != -1) {
            return "<" + baseName + " advice>";
        }
        return baseName;
    }
}

