/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Block;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.Label;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FinallyFlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class TryStatement
extends SubRoutineStatement {
    public Block tryBlock;
    public Block[] catchBlocks;
    public Argument[] catchArguments;
    public Block finallyBlock;
    BlockScope scope;
    private boolean isSubRoutineEscaping = false;
    public UnconditionalFlowInfo subRoutineInits;
    ReferenceBinding[] caughtExceptionTypes;
    boolean tryBlockExit;
    boolean[] catchExits;
    public int[] preserveExceptionHandler;
    Label subRoutineStartLabel;
    public LocalVariableBinding anyExceptionVariable;
    public LocalVariableBinding returnAddressVariable;
    public LocalVariableBinding secretReturnValue;
    public static final char[] SecretReturnName = " returnAddress".toCharArray();
    public static final char[] SecretAnyHandlerName = " anyExceptionHandler".toCharArray();
    public static final char[] SecretLocalDeclarationName = " returnValue".toCharArray();
    int preTryInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo tryInfo;
        UnconditionalFlowInfo subInfo;
        FinallyFlowContext finallyContext;
        InsideSubRoutineFlowContext insideSubContext;
        this.preTryInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        if (this.anyExceptionVariable != null) {
            this.anyExceptionVariable.useFlag = 1;
        }
        if (this.returnAddressVariable != null) {
            this.returnAddressVariable.useFlag = 1;
        }
        if (this.subRoutineStartLabel == null) {
            insideSubContext = null;
            finallyContext = null;
            subInfo = null;
        } else {
            insideSubContext = new InsideSubRoutineFlowContext(flowContext, this);
            finallyContext = new FinallyFlowContext(flowContext, this.finallyBlock);
            subInfo = this.finallyBlock.analyseCode(currentScope, finallyContext, flowInfo.copy().unconditionalInits().discardNullRelatedInitializations()).unconditionalInits();
            if (subInfo == FlowInfo.DEAD_END) {
                this.isSubRoutineEscaping = true;
                this.scope.problemReporter().finallyMustCompleteNormally(this.finallyBlock);
            }
            this.subRoutineInits = subInfo;
        }
        ExceptionHandlingFlowContext handlingContext = new ExceptionHandlingFlowContext(insideSubContext == null ? flowContext : insideSubContext, this.tryBlock, this.caughtExceptionTypes, this.scope, flowInfo.unconditionalInits());
        if (this.tryBlock.isEmptyBlock()) {
            tryInfo = flowInfo;
            this.tryBlockExit = false;
        } else {
            tryInfo = this.tryBlock.analyseCode(currentScope, handlingContext, flowInfo.copy());
            this.tryBlockExit = !tryInfo.isReachable();
        }
        handlingContext.complainIfUnusedExceptionHandlers(this.scope, this);
        if (this.catchArguments != null) {
            int catchCount = this.catchBlocks.length;
            this.catchExits = new boolean[catchCount];
            int i = 0;
            while (i < catchCount) {
                FlowInfo catchInfo = flowInfo.copy().unconditionalInits().addPotentialInitializationsFrom(handlingContext.initsOnException(this.caughtExceptionTypes[i]).unconditionalInits()).addPotentialInitializationsFrom(tryInfo.unconditionalInits()).addPotentialInitializationsFrom(handlingContext.initsOnReturn);
                LocalVariableBinding catchArg = this.catchArguments[i].binding;
                FlowContext catchContext = insideSubContext == null ? flowContext : insideSubContext;
                catchInfo.markAsDefinitelyAssigned(catchArg);
                catchInfo.markAsDefinitelyNonNull(catchArg);
                if (this.tryBlock.statements == null) {
                    catchInfo.setReachMode(1);
                }
                this.catchExits[i] = !(catchInfo = this.catchBlocks[i].analyseCode(currentScope, catchContext, catchInfo)).isReachable();
                tryInfo = tryInfo.mergedWith(catchInfo.unconditionalInits());
                ++i;
            }
        }
        if (this.subRoutineStartLabel == null) {
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(tryInfo);
            return tryInfo;
        }
        finallyContext.complainOnDeferredChecks(tryInfo.isReachable() ? tryInfo.addPotentialInitializationsFrom(insideSubContext.initsOnReturn) : insideSubContext.initsOnReturn, currentScope);
        if (subInfo == FlowInfo.DEAD_END) {
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(subInfo);
            return subInfo;
        }
        FlowInfo mergedInfo = tryInfo.addInitializationsFrom(subInfo);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public boolean isSubRoutineEscaping() {
        return this.isSubRoutineEscaping;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        boolean tryBlockHasSomeCode;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if (this.anyExceptionLabelsCount > 0) {
            this.anyExceptionLabels = SubRoutineStatement.NO_EXCEPTION_HANDLER;
            this.anyExceptionLabelsCount = 0;
        }
        int pc = codeStream.position;
        boolean NO_FINALLY = false;
        boolean FINALLY_SUBROUTINE = true;
        int FINALLY_DOES_NOT_COMPLETE = 2;
        int FINALLY_MUST_BE_INLINED = 3;
        int finallyMode = this.subRoutineStartLabel == null ? 0 : (this.isSubRoutineEscaping ? 2 : (this.scope.compilerOptions().inlineJsrBytecode ? 3 : 1));
        boolean requiresNaturalExit = false;
        int maxCatches = this.catchArguments == null ? 0 : this.catchArguments.length;
        ExceptionLabel[] exceptionLabels = new ExceptionLabel[maxCatches];
        int i = 0;
        while (i < maxCatches) {
            exceptionLabels[i] = new ExceptionLabel(codeStream, this.catchArguments[i].binding.type);
            ++i;
        }
        if (this.subRoutineStartLabel != null) {
            this.subRoutineStartLabel.initialize(codeStream);
            this.enterAnyExceptionHandler(codeStream);
        }
        this.tryBlock.generateCode(this.scope, codeStream);
        boolean bl = tryBlockHasSomeCode = codeStream.position != pc;
        if (tryBlockHasSomeCode) {
            Label naturalExitLabel = new Label(codeStream);
            if (!this.tryBlockExit) {
                int position = codeStream.position;
                switch (finallyMode) {
                    case 1: 
                    case 3: {
                        requiresNaturalExit = true;
                    }
                    case 0: {
                        codeStream.goto_(naturalExitLabel);
                        break;
                    }
                    case 2: {
                        codeStream.goto_(this.subRoutineStartLabel);
                    }
                }
                codeStream.updateLastRecordedEndPC(this.tryBlock.scope, position);
            }
            int i2 = 0;
            while (i2 < maxCatches) {
                exceptionLabels[i2].placeEnd();
                ++i2;
            }
            if (this.catchArguments != null) {
                i2 = 0;
                while (i2 < maxCatches) {
                    if (this.preTryInitStateIndex != -1) {
                        codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preTryInitStateIndex);
                    }
                    exceptionLabels[i2].place();
                    codeStream.incrStackSize(1);
                    int varPC = codeStream.position;
                    LocalVariableBinding catchVar = this.catchArguments[i2].binding;
                    if (catchVar.resolvedPosition != -1) {
                        codeStream.store(catchVar, false);
                        catchVar.recordInitializationStartPC(codeStream.position);
                        codeStream.addVisibleLocalVariable(catchVar);
                    } else {
                        codeStream.pop();
                    }
                    codeStream.recordPositionsFrom(varPC, this.catchArguments[i2].sourceStart);
                    this.catchBlocks[i2].generateCode(this.scope, codeStream);
                    if (!this.catchExits[i2]) {
                        switch (finallyMode) {
                            case 1: 
                            case 3: {
                                requiresNaturalExit = true;
                            }
                            case 0: {
                                codeStream.goto_(naturalExitLabel);
                                break;
                            }
                            case 2: {
                                codeStream.goto_(this.subRoutineStartLabel);
                            }
                        }
                    }
                    ++i2;
                }
            }
            this.exitAnyExceptionHandler();
            ExceptionLabel naturalExitExceptionHandler = finallyMode == 1 && requiresNaturalExit ? new ExceptionLabel(codeStream, null) : null;
            int finallySequenceStartPC = codeStream.position;
            if (this.subRoutineStartLabel != null) {
                int position;
                this.placeAllAnyExceptionHandlers();
                if (naturalExitExceptionHandler != null) {
                    naturalExitExceptionHandler.place();
                }
                if (this.preTryInitStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preTryInitStateIndex);
                }
                codeStream.incrStackSize(1);
                switch (finallyMode) {
                    case 1: {
                        codeStream.store(this.anyExceptionVariable, false);
                        codeStream.jsr(this.subRoutineStartLabel);
                        codeStream.recordPositionsFrom(finallySequenceStartPC, this.finallyBlock.sourceStart);
                        position = codeStream.position;
                        codeStream.load(this.anyExceptionVariable);
                        codeStream.athrow();
                        codeStream.recordPositionsFrom(position, this.finallyBlock.sourceEnd);
                        this.subRoutineStartLabel.place();
                        codeStream.incrStackSize(1);
                        position = codeStream.position;
                        codeStream.store(this.returnAddressVariable, false);
                        codeStream.recordPositionsFrom(position, this.finallyBlock.sourceStart);
                        this.finallyBlock.generateCode(this.scope, codeStream);
                        position = codeStream.position;
                        codeStream.ret(this.returnAddressVariable.resolvedPosition);
                        codeStream.recordPositionsFrom(position, this.finallyBlock.sourceEnd);
                        break;
                    }
                    case 3: {
                        codeStream.store(this.anyExceptionVariable, false);
                        codeStream.recordPositionsFrom(finallySequenceStartPC, this.finallyBlock.sourceStart);
                        this.finallyBlock.generateCode(currentScope, codeStream);
                        position = codeStream.position;
                        codeStream.load(this.anyExceptionVariable);
                        codeStream.athrow();
                        this.subRoutineStartLabel.place();
                        codeStream.recordPositionsFrom(position, this.finallyBlock.sourceEnd);
                        break;
                    }
                    case 2: {
                        codeStream.pop();
                        this.subRoutineStartLabel.place();
                        codeStream.recordPositionsFrom(finallySequenceStartPC, this.finallyBlock.sourceStart);
                        this.finallyBlock.generateCode(this.scope, codeStream);
                    }
                }
                naturalExitLabel.place();
                if (requiresNaturalExit) {
                    switch (finallyMode) {
                        case 1: {
                            position = codeStream.position;
                            naturalExitExceptionHandler.placeStart();
                            codeStream.jsr(this.subRoutineStartLabel);
                            naturalExitExceptionHandler.placeEnd();
                            codeStream.recordPositionsFrom(position, this.finallyBlock.sourceEnd);
                            break;
                        }
                        case 3: {
                            if (this.preTryInitStateIndex != -1) {
                                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preTryInitStateIndex);
                            }
                            this.finallyBlock.generateCode(this.scope, codeStream);
                            break;
                        }
                    }
                }
            } else {
                naturalExitLabel.place();
            }
        } else if (this.subRoutineStartLabel != null) {
            this.finallyBlock.generateCode(this.scope, codeStream);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateSubRoutineInvocation(BlockScope currentScope, CodeStream codeStream) {
        if (this.isSubRoutineEscaping) {
            codeStream.goto_(this.subRoutineStartLabel);
        } else if (currentScope.compilerOptions().inlineJsrBytecode) {
            this.exitAnyExceptionHandler();
            this.finallyBlock.generateCode(currentScope, codeStream);
            this.enterAnyExceptionHandler(codeStream);
        } else {
            codeStream.jsr(this.subRoutineStartLabel);
        }
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        ASTNode.printIndent(indent, output).append("try \n");
        this.tryBlock.printStatement(indent + 1, output);
        if (this.catchBlocks != null) {
            int i = 0;
            while (i < this.catchBlocks.length) {
                output.append('\n');
                ASTNode.printIndent(indent, output).append("catch (");
                this.catchArguments[i].print(0, output).append(") ");
                this.catchBlocks[i].printStatement(indent + 1, output);
                ++i;
            }
        }
        if (this.finallyBlock != null) {
            output.append('\n');
            ASTNode.printIndent(indent, output).append("finally\n");
            this.finallyBlock.printStatement(indent + 1, output);
        }
        return output;
    }

    public void resolve(BlockScope upperScope) {
        this.scope = new BlockScope(upperScope);
        BlockScope tryScope = new BlockScope(this.scope);
        BlockScope finallyScope = null;
        if (this.finallyBlock != null) {
            if (this.finallyBlock.isEmptyBlock()) {
                if ((this.finallyBlock.bits & 8) != 0) {
                    this.scope.problemReporter().undocumentedEmptyBlock(this.finallyBlock.sourceStart, this.finallyBlock.sourceEnd);
                }
            } else {
                MethodBinding methodBinding;
                finallyScope = new BlockScope(this.scope, false);
                MethodScope methodScope = this.scope.methodScope();
                if (!upperScope.compilerOptions().inlineJsrBytecode) {
                    this.returnAddressVariable = new LocalVariableBinding(SecretReturnName, (TypeBinding)upperScope.getJavaLangObject(), 0, false);
                    finallyScope.addLocalVariable(this.returnAddressVariable);
                    this.returnAddressVariable.setConstant(ASTNode.NotAConstant);
                }
                this.subRoutineStartLabel = new Label();
                this.anyExceptionVariable = new LocalVariableBinding(SecretAnyHandlerName, (TypeBinding)this.scope.getJavaLangThrowable(), 0, false);
                finallyScope.addLocalVariable(this.anyExceptionVariable);
                this.anyExceptionVariable.setConstant(ASTNode.NotAConstant);
                if (!methodScope.isInsideInitializer() && (methodBinding = ((AbstractMethodDeclaration)methodScope.referenceContext).binding) != null) {
                    TypeBinding methodReturnType = methodBinding.returnType;
                    if (methodReturnType.id != 6) {
                        this.secretReturnValue = new LocalVariableBinding(SecretLocalDeclarationName, methodReturnType, 0, false);
                        finallyScope.addLocalVariable(this.secretReturnValue);
                        this.secretReturnValue.setConstant(ASTNode.NotAConstant);
                    }
                }
                this.finallyBlock.resolveUsing(finallyScope);
                finallyScope.shiftScopes = new BlockScope[this.catchArguments == null ? 1 : this.catchArguments.length + 1];
                finallyScope.shiftScopes[0] = tryScope;
            }
        }
        this.tryBlock.resolveUsing(tryScope);
        if (this.catchBlocks != null) {
            int length = this.catchArguments.length;
            TypeBinding[] argumentTypes = new TypeBinding[length];
            boolean catchHasError = false;
            int i = 0;
            while (i < length) {
                BlockScope catchScope = new BlockScope(this.scope);
                if (finallyScope != null) {
                    finallyScope.shiftScopes[i + 1] = catchScope;
                }
                if ((argumentTypes[i] = this.catchArguments[i].resolveForCatch(catchScope)) == null) {
                    catchHasError = true;
                }
                this.catchBlocks[i].resolveUsing(catchScope);
                ++i;
            }
            if (catchHasError) {
                return;
            }
            this.caughtExceptionTypes = new ReferenceBinding[length];
            i = 0;
            while (i < length) {
                this.caughtExceptionTypes[i] = (ReferenceBinding)argumentTypes[i];
                int j = 0;
                while (j < i) {
                    if (this.caughtExceptionTypes[i].isCompatibleWith(argumentTypes[j])) {
                        this.scope.problemReporter().wrongSequenceOfExceptionTypesError(this, this.caughtExceptionTypes[i], i, argumentTypes[j]);
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            this.caughtExceptionTypes = new ReferenceBinding[0];
        }
        if (finallyScope != null) {
            this.scope.addSubscope(finallyScope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.tryBlock.traverse(visitor, this.scope);
            if (this.catchArguments != null) {
                int i = 0;
                int max = this.catchBlocks.length;
                while (i < max) {
                    this.catchArguments[i].traverse(visitor, this.scope);
                    this.catchBlocks[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.finallyBlock != null) {
                this.finallyBlock.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

