/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.lookup;

import java.io.File;
import org.aspectj.ajdt.internal.core.builder.EclipseAdapterUtils;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemHandler;

public class EclipseSourceLocation
implements ISourceLocation {
    private static String NO_CONTEXT = "USE_NULL--NO_CONTEXT_AVAILABLE";
    CompilationResult result;
    int startPos;
    int endPos;
    File file;
    int startLine = -1;
    int endLine = -1;
    int column = -1;
    String context;

    public EclipseSourceLocation(CompilationResult result, int startPos, int endPos) {
        this.result = result;
        this.startPos = startPos;
        this.endPos = endPos;
    }

    public CompilationResult getCompilationResult() {
        return this.result;
    }

    public int getOffset() {
        return this.startPos;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public File getSourceFile() {
        if (null == this.file) {
            this.file = null == this.result || null == this.result.fileName || 0 == this.result.fileName.length ? ISourceLocation.NO_FILE : new File(new String(this.result.fileName));
        }
        return this.file;
    }

    public int getLine() {
        if (-1 == this.startLine) {
            this.startLine = ProblemHandler.searchLineNumber(this.result.lineSeparatorPositions, this.startPos);
        }
        return this.startLine;
    }

    public int getColumn() {
        if (-1 == this.column) {
            int lineNumber = this.getLine();
            if (0 < lineNumber && lineNumber < this.result.lineSeparatorPositions.length) {
                int lineStart = this.result.lineSeparatorPositions[lineNumber];
                int col = this.startPos - lineStart;
                this.column = 0 <= col ? col : 0;
            } else if (0 < lineNumber && lineNumber == this.result.lineSeparatorPositions.length) {
                this.column = 0;
            }
        }
        return this.column;
    }

    public int getEndLine() {
        if (-1 == this.endLine) {
            this.endLine = ProblemHandler.searchLineNumber(this.result.lineSeparatorPositions, this.endPos);
        }
        return this.endLine;
    }

    public String getContext() {
        if (null == this.context) {
            ICompilationUnit compilationUnit = this.result.compilationUnit;
            IProblem[] problems = this.result.problems;
            this.context = null == compilationUnit || null == problems || 1 != problems.length ? NO_CONTEXT : EclipseAdapterUtils.makeLocationContext(compilationUnit, problems[0]);
        }
        return NO_CONTEXT == this.context ? null : this.context;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getSourceFile() != ISourceLocation.NO_FILE) {
            sb.append(this.getSourceFile().getPath());
            sb.append(":");
        }
        sb.append("" + this.getLine());
        if (this.getColumn() != 0) {
            sb.append(":" + this.getColumn());
        }
        if (this.getOffset() >= 0) {
            sb.append("::").append(this.getOffset());
        }
        return sb.toString();
    }
}

