/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.Proceed;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.InlineAccessFieldBinding;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeFieldBinding;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMethodBinding;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedFieldBinding;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedHandler;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ResolvedMember;

public class AccessForInlineVisitor
extends ASTVisitor {
    PrivilegedHandler handler;
    AspectDeclaration inAspect;
    EclipseFactory world;
    public boolean isInlinable = true;

    public AccessForInlineVisitor(AspectDeclaration inAspect, PrivilegedHandler handler) {
        this.inAspect = inAspect;
        this.world = inAspect.factory;
        this.handler = handler;
    }

    public void endVisit(SingleNameReference ref, BlockScope scope) {
        if (ref.binding instanceof FieldBinding) {
            ref.binding = this.getAccessibleField((FieldBinding)ref.binding, ref.actualReceiverType);
        }
    }

    public void endVisit(QualifiedNameReference ref, BlockScope scope) {
        if (ref.binding instanceof FieldBinding) {
            ref.binding = this.getAccessibleField((FieldBinding)ref.binding, ref.actualReceiverType);
        }
        if (ref.otherBindings != null && ref.otherBindings.length > 0) {
            TypeBinding receiverType = ref.binding instanceof FieldBinding ? ((FieldBinding)ref.binding).type : (ref.binding instanceof VariableBinding ? ((VariableBinding)ref.binding).type : ref.otherBindings[0].declaringClass);
            int len = ref.otherBindings.length;
            for (int i = 0; i < len; ++i) {
                FieldBinding binding = ref.otherBindings[i];
                ref.otherBindings[i] = this.getAccessibleField(binding, receiverType);
                receiverType = binding.type;
            }
        }
    }

    public void endVisit(FieldReference ref, BlockScope scope) {
        ref.binding = this.getAccessibleField(ref.binding, ref.receiverType);
    }

    public void endVisit(MessageSend send, BlockScope scope) {
        if (send instanceof Proceed) {
            return;
        }
        if (send.binding == null || !send.binding.isValidBinding()) {
            return;
        }
        if (send.isSuperAccess() && !send.binding.isStatic()) {
            send.receiver = new ThisReference(send.sourceStart, send.sourceEnd);
            MethodBinding superAccessBinding = this.getSuperAccessMethod(send.binding);
            AstUtil.replaceMethodBinding(send, superAccessBinding);
        } else if (!this.isPublic(send.binding)) {
            send.syntheticAccessor = this.getAccessibleMethod(send.binding, send.actualReceiverType);
        }
    }

    public void endVisit(AllocationExpression send, BlockScope scope) {
        if (send.binding == null || !send.binding.isValidBinding()) {
            return;
        }
        if (this.isPublic(send.binding)) {
            return;
        }
        this.makePublic(send.binding.declaringClass);
        send.binding = this.handler.getPrivilegedAccessMethod(send.binding, send);
    }

    public void endVisit(QualifiedTypeReference ref, BlockScope scope) {
        this.makePublic(ref.resolvedType);
    }

    public void endVisit(SingleTypeReference ref, BlockScope scope) {
        this.makePublic(ref.resolvedType);
    }

    private FieldBinding getAccessibleField(FieldBinding binding, TypeBinding receiverType) {
        ResolvedMember m;
        if (binding == null || !binding.isValidBinding()) {
            return binding;
        }
        this.makePublic(receiverType);
        if (this.isPublic(binding)) {
            return binding;
        }
        if (binding instanceof PrivilegedFieldBinding) {
            return binding;
        }
        if (binding instanceof InterTypeFieldBinding) {
            return binding;
        }
        if (binding.isPrivate() && binding.declaringClass != this.inAspect.binding) {
            binding.modifiers = AstUtil.makePackageVisible(binding.modifiers);
        }
        if (this.inAspect.accessForInline.containsKey(m = this.world.makeResolvedMember(binding, receiverType))) {
            return (FieldBinding)this.inAspect.accessForInline.get(m);
        }
        InlineAccessFieldBinding ret = new InlineAccessFieldBinding(this.inAspect, binding, m);
        this.inAspect.accessForInline.put(m, ret);
        return ret;
    }

    private MethodBinding getAccessibleMethod(MethodBinding binding, TypeBinding receiverType) {
        if (!binding.isValidBinding()) {
            return binding;
        }
        this.makePublic(receiverType);
        if (this.isPublic(binding)) {
            return binding;
        }
        if (binding instanceof InterTypeMethodBinding) {
            return binding;
        }
        ResolvedMember m = null;
        if (binding.isPrivate() && binding.declaringClass != this.inAspect.binding) {
            binding.modifiers = AstUtil.makePackageVisible(binding.modifiers);
            m = this.world.makeResolvedMember(binding);
        } else {
            m = this.world.makeResolvedMember(binding, receiverType);
        }
        if (this.inAspect.accessForInline.containsKey(m)) {
            return (MethodBinding)this.inAspect.accessForInline.get(m);
        }
        MethodBinding ret = this.world.makeMethodBinding(AjcMemberMaker.inlineAccessMethodForMethod(this.inAspect.typeX, m));
        this.inAspect.accessForInline.put(m, ret);
        return ret;
    }

    private MethodBinding getSuperAccessMethod(MethodBinding binding) {
        ResolvedMember m = this.world.makeResolvedMember(binding);
        ResolvedMember superAccessMember = AjcMemberMaker.superAccessMethod(this.inAspect.typeX, m);
        if (this.inAspect.superAccessForInline.containsKey(superAccessMember)) {
            return ((SuperAccessMethodPair)this.inAspect.superAccessForInline.get((Object)superAccessMember)).accessMethod;
        }
        MethodBinding ret = this.world.makeMethodBinding(superAccessMember);
        this.inAspect.superAccessForInline.put(superAccessMember, new SuperAccessMethodPair(m, ret));
        return ret;
    }

    private boolean isPublic(FieldBinding fieldBinding) {
        if (fieldBinding instanceof InterTypeFieldBinding) {
            return true;
        }
        return fieldBinding.isPublic();
    }

    private boolean isPublic(MethodBinding methodBinding) {
        if (methodBinding instanceof InterTypeMethodBinding) {
            return true;
        }
        return methodBinding.isPublic();
    }

    private void makePublic(TypeBinding binding) {
        if (binding == null || !binding.isValidBinding()) {
            return;
        }
        if (binding instanceof ReferenceBinding) {
            ReferenceBinding rb = (ReferenceBinding)binding;
            if (!rb.isPublic()) {
                this.handler.notePrivilegedTypeAccess(rb, null);
            }
        } else if (binding instanceof ArrayBinding) {
            this.makePublic(((ArrayBinding)binding).leafComponentType);
        } else {
            return;
        }
    }

    public void endVisit(AssertStatement assertStatement, BlockScope scope) {
        this.isInlinable = false;
    }

    public void endVisit(ClassLiteralAccess classLiteral, BlockScope scope) {
        this.isInlinable = false;
    }

    public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
        return false;
    }

    static class SuperAccessMethodPair {
        public ResolvedMember originalMethod;
        public MethodBinding accessMethod;

        public SuperAccessMethodPair(ResolvedMember originalMethod, MethodBinding accessMethod) {
            this.originalMethod = originalMethod;
            this.accessMethod = accessMethod;
        }
    }
}

