/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.swing.BrowserViewPanel;
import org.aspectj.ajde.ui.swing.IconRegistry;
import org.aspectj.asm.IProgramElement;

class BrowserView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private BrowserViewPanel slaveView;
    private boolean slaveViewVisible = false;
    private String lastSelectedConfig = "";
    private IconRegistry icons = null;
    private BorderLayout borderLayout1 = new BorderLayout();
    private Border default_border;
    private JPanel toolBar_panel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    JPanel mainToolBar_panel = new JPanel();
    JToolBar config_toolBar = new JToolBar();
    JComboBox configs_comboBox = null;
    BorderLayout borderLayout3 = new BorderLayout();
    JToolBar nav_toolBar = new JToolBar();
    JButton forward_button = new JButton();
    JButton back_button = new JButton();
    GridLayout gridLayout1 = new GridLayout();
    JSplitPane views_splitPane = new JSplitPane();
    JToolBar command_toolBar = new JToolBar();
    JToggleButton splitView_button = new JToggleButton();
    JToggleButton zoomToFile_button = new JToggleButton();
    JButton joinpointProbe_button = new JButton();

    public BrowserView(BrowserViewPanel masterView, BrowserViewPanel slaveView, IconRegistry icons) {
        try {
            this.slaveView = slaveView;
            this.icons = icons;
            this.configs_comboBox = new JComboBox<Object>(Ajde.getDefault().getProjectProperties().getBuildConfigFiles().toArray());
            this.configs_comboBox.setRenderer(new ConfigsCellRenderer());
            if (Ajde.getDefault().getProjectProperties().getBuildConfigFiles().size() > 0) {
                Ajde.getDefault().getConfigurationManager().setActiveConfigFile((String)Ajde.getDefault().getProjectProperties().getBuildConfigFiles().get(0));
            }
            this.jbInit();
            this.fixButtonBorders();
            this.views_splitPane.add((Component)masterView, "top");
            this.views_splitPane.add((Component)slaveView, "bottom");
            this.setSlaveViewVisible(false);
            this.nav_toolBar.remove(this.joinpointProbe_button);
        }
        catch (Exception e) {
            Ajde.getDefault().getErrorHandler().handleError("Could not initialize GUI.", e);
        }
    }

    public void setSlaveViewVisible(boolean visible) {
        this.slaveViewVisible = visible;
        if (visible) {
            this.views_splitPane.add((Component)this.slaveView, "bottom");
            this.views_splitPane.setDividerLocation(this.getHeight() - 250);
        } else {
            this.views_splitPane.remove(this.slaveView);
            this.views_splitPane.setDividerLocation(this.getHeight());
        }
    }

    public boolean isSlaveViewVisible() {
        return this.slaveViewVisible;
    }

    public void updateConfigs(List configsList) {
        this.configs_comboBox.removeAllItems();
        Iterator it = configsList.iterator();
        while (it.hasNext()) {
            this.configs_comboBox.addItem((String)it.next());
        }
    }

    public void setSelectedConfig(String config) {
        for (int i = 0; i < this.configs_comboBox.getItemCount(); ++i) {
            if (!this.configs_comboBox.getItemAt(i).equals(config)) continue;
            this.configs_comboBox.setSelectedIndex(i);
        }
    }

    public String getSelectedConfig() {
        return (String)this.configs_comboBox.getSelectedItem();
    }

    private void fixButtonBorders() {
        this.back_button.setBorder(BorderFactory.createEmptyBorder());
        this.forward_button.setBorder(BorderFactory.createEmptyBorder());
        this.zoomToFile_button.setBorder(BorderFactory.createEmptyBorder());
        this.splitView_button.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, Color.blue));
    }

    private void jbInit() throws Exception {
        this.default_border = BorderFactory.createEmptyBorder();
        this.setLayout(this.borderLayout1);
        this.toolBar_panel.setLayout(this.borderLayout2);
        this.toolBar_panel.setBorder(BorderFactory.createEtchedBorder());
        this.config_toolBar.setBorder(this.default_border);
        this.config_toolBar.setFloatable(false);
        this.configs_comboBox.setPreferredSize(new Dimension(200, 20));
        this.configs_comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserView.this.configs_comboBox_actionPerformed(e);
            }
        });
        this.configs_comboBox.setMinimumSize(new Dimension(40, 20));
        this.configs_comboBox.setFont(new Font("SansSerif", 0, 11));
        this.mainToolBar_panel.setLayout(this.borderLayout3);
        this.nav_toolBar.setFloatable(false);
        this.nav_toolBar.setBorder(this.default_border);
        this.forward_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserView.this.forward_button_actionPerformed(e);
            }
        });
        this.forward_button.setIcon(this.icons.getForwardIcon());
        this.forward_button.setToolTipText("Navigate forward");
        this.forward_button.setPreferredSize(new Dimension(20, 20));
        this.forward_button.setMinimumSize(new Dimension(20, 20));
        this.forward_button.setBorder(this.default_border);
        this.forward_button.setMaximumSize(new Dimension(24, 20));
        this.back_button.setMaximumSize(new Dimension(24, 20));
        this.back_button.setBorder(this.default_border);
        this.back_button.setMinimumSize(new Dimension(20, 20));
        this.back_button.setPreferredSize(new Dimension(20, 20));
        this.back_button.setToolTipText("Navigate back");
        this.back_button.setIcon(this.icons.getBackIcon());
        this.back_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserView.this.back_button_actionPerformed(e);
            }
        });
        this.views_splitPane.setOrientation(0);
        this.views_splitPane.setDividerSize(2);
        this.command_toolBar.setBorder(this.default_border);
        this.command_toolBar.setFloatable(false);
        this.splitView_button.setFont(new Font("Dialog", 0, 11));
        this.splitView_button.setBorder(this.default_border);
        this.splitView_button.setMaximumSize(new Dimension(24, 24));
        this.splitView_button.setPreferredSize(new Dimension(20, 20));
        this.splitView_button.setToolTipText("Togge split-tree view mode");
        this.splitView_button.setIcon(this.icons.getSplitStructureViewIcon());
        this.splitView_button.setSelectedIcon(this.icons.getMergeStructureViewIcon());
        this.splitView_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.zoomToFile_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.zoomToFile_button.setIcon(this.icons.getZoomStructureToFileModeIcon());
        this.zoomToFile_button.setSelectedIcon(this.icons.getZoomStructureToGlobalModeIcon());
        this.zoomToFile_button.setBorder(BorderFactory.createRaisedBevelBorder());
        this.zoomToFile_button.setMaximumSize(new Dimension(24, 24));
        this.zoomToFile_button.setPreferredSize(new Dimension(20, 20));
        this.zoomToFile_button.setToolTipText("Toggle file-view mode");
        this.zoomToFile_button.setFont(new Font("Dialog", 0, 11));
        this.joinpointProbe_button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BrowserView.this.joinpointProbe_button_actionPerformed(e);
            }
        });
        this.joinpointProbe_button.setIcon(this.icons.getStructureSwingIcon(IProgramElement.Kind.POINTCUT));
        this.joinpointProbe_button.setToolTipText("Create joinpoint probe");
        this.joinpointProbe_button.setPreferredSize(new Dimension(20, 20));
        this.joinpointProbe_button.setMinimumSize(new Dimension(20, 20));
        this.joinpointProbe_button.setBorder(this.default_border);
        this.joinpointProbe_button.setMaximumSize(new Dimension(24, 20));
        this.add((Component)this.toolBar_panel, "North");
        this.toolBar_panel.add((Component)this.mainToolBar_panel, "North");
        this.mainToolBar_panel.add((Component)this.config_toolBar, "Center");
        this.config_toolBar.add((Component)this.configs_comboBox, null);
        this.mainToolBar_panel.add((Component)this.nav_toolBar, "East");
        this.nav_toolBar.add((Component)this.splitView_button, null);
        this.nav_toolBar.add((Component)this.zoomToFile_button, null);
        this.nav_toolBar.add((Component)this.joinpointProbe_button, null);
        this.nav_toolBar.add((Component)this.back_button, null);
        this.nav_toolBar.add((Component)this.forward_button, null);
        this.mainToolBar_panel.add((Component)this.command_toolBar, "West");
        this.add((Component)this.views_splitPane, "Center");
        this.views_splitPane.setDividerLocation(400);
    }

    void forward_button_actionPerformed(ActionEvent e) {
    }

    void back_button_actionPerformed(ActionEvent e) {
    }

    void configDesigner_button_mouseClicked(MouseEvent e) {
    }

    void configDesigner_button_mousePressed(MouseEvent e) {
    }

    void configDesigner_button_mouseReleased(MouseEvent e) {
    }

    void configDesigner_button_mouseEntered(MouseEvent e) {
    }

    void configDesigner_button_mouseExited(MouseEvent e) {
    }

    void configDesigner_button_actionPerformed(ActionEvent e) {
    }

    void viewManager_button_mouseClicked(MouseEvent e) {
    }

    void viewManager_button_mousePressed(MouseEvent e) {
    }

    void viewManager_button_mouseReleased(MouseEvent e) {
    }

    void viewManager_button_mouseEntered(MouseEvent e) {
    }

    void viewManager_button_mouseExited(MouseEvent e) {
    }

    void viewManager_button_actionPerformed(ActionEvent e) {
    }

    void configs_comboBox_actionPerformed(ActionEvent e) {
        if (this.configs_comboBox.getSelectedItem() != null && !this.configs_comboBox.getSelectedItem().toString().equals(this.lastSelectedConfig)) {
            this.lastSelectedConfig = this.configs_comboBox.getSelectedItem().toString();
            Ajde.getDefault().getConfigurationManager().setActiveConfigFile(this.lastSelectedConfig);
        }
    }

    private void joinpointProbe_button_actionPerformed(ActionEvent e) {
    }

    static class ConfigsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 8795959045339903340L;

        public ConfigsCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return this;
            }
            File file = new File(value.toString());
            this.setText(file.getName());
            this.setBackground(isSelected ? Color.gray : Color.lightGray);
            return this;
        }
    }
}

