/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui.swing;

import java.awt.Component;
import java.awt.Frame;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildListener;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.EditorAdapter;
import org.aspectj.ajde.ErrorHandler;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.ui.FileStructureView;
import org.aspectj.ajde.ui.IdeUIAdapter;
import org.aspectj.ajde.ui.UserPreferencesAdapter;
import org.aspectj.ajde.ui.internal.AjcBuildOptions;
import org.aspectj.ajde.ui.swing.AjdeErrorHandler;
import org.aspectj.ajde.ui.swing.BrowserViewManager;
import org.aspectj.ajde.ui.swing.DefaultBuildProgressMonitor;
import org.aspectj.ajde.ui.swing.IconRegistry;
import org.aspectj.ajde.ui.swing.OptionsFrame;
import org.aspectj.ajde.ui.swing.StructureViewPanel;
import org.aspectj.ajde.ui.swing.SwingTreeViewNodeFactory;
import org.aspectj.ajde.ui.swing.TreeViewBuildConfigEditor;

public class AjdeUIManager {
    protected static final AjdeUIManager INSTANCE = new AjdeUIManager();
    private BrowserViewManager viewManager = null;
    private AjcBuildOptions buildOptionsAdapter = null;
    private IdeUIAdapter ideUIAdapter = null;
    private TreeViewBuildConfigEditor buildConfigEditor = null;
    private IconRegistry iconRegistry;
    private boolean initialized = false;
    private OptionsFrame optionsFrame = null;
    private Frame rootFrame = null;
    private StructureViewPanel fileStructurePanel = null;
    private final BuildListener STATUS_TEXT_UPDATER = new BuildListener(){

        public void compileStarted(String buildConfigFile) {
            AjdeUIManager.this.ideUIAdapter.displayStatusInformation(" Building: " + buildConfigFile + "...");
        }

        public void compileFinished(String buildConfigFile, int buildTime, boolean succeeded, boolean warnings) {
            int timeInSeconds = buildTime / 1000;
            if (succeeded) {
                AjdeUIManager.this.ideUIAdapter.displayStatusInformation(" Build succeeded in " + timeInSeconds + " second(s).");
            } else {
                AjdeUIManager.this.ideUIAdapter.displayStatusInformation(" Build failed in " + timeInSeconds + " second(s)");
            }
        }

        public void compileAborted(String buildConfigFile, String message) {
            AjdeUIManager.this.ideUIAdapter.displayStatusInformation("Compile aborted: " + message);
        }
    };

    public void init(EditorAdapter editorAdapter, TaskListManager taskListManager, ProjectPropertiesAdapter projectProperties, UserPreferencesAdapter userPreferencesAdapter, IdeUIAdapter ideUIAdapter, IconRegistry iconRegistry, Frame rootFrame, boolean useFileView) {
        this.init(editorAdapter, taskListManager, projectProperties, userPreferencesAdapter, ideUIAdapter, iconRegistry, rootFrame, new DefaultBuildProgressMonitor(rootFrame), new AjdeErrorHandler(), useFileView);
    }

    public void init(EditorAdapter editorAdapter, TaskListManager taskListManager, ProjectPropertiesAdapter projectProperties, UserPreferencesAdapter userPreferencesAdapter, IdeUIAdapter ideUIAdapter, IconRegistry iconRegistry, Frame rootFrame, BuildProgressMonitor progressMonitor, ErrorHandler errorHandler, boolean useFileView) {
        try {
            this.iconRegistry = iconRegistry;
            this.ideUIAdapter = ideUIAdapter;
            this.buildOptionsAdapter = new AjcBuildOptions(userPreferencesAdapter);
            this.buildConfigEditor = new TreeViewBuildConfigEditor();
            this.rootFrame = rootFrame;
            Ajde.init(editorAdapter, taskListManager, progressMonitor, projectProperties, this.buildOptionsAdapter, new SwingTreeViewNodeFactory(iconRegistry), ideUIAdapter, errorHandler);
            Ajde.getDefault().getBuildManager().addListener(this.STATUS_TEXT_UPDATER);
            if (useFileView) {
                FileStructureView structureView = Ajde.getDefault().getStructureViewManager().createViewForSourceFile(Ajde.getDefault().getEditorAdapter().getCurrFile(), Ajde.getDefault().getStructureViewManager().getDefaultViewProperties());
                Ajde.getDefault().getStructureViewManager().setDefaultFileView(structureView);
                this.fileStructurePanel = new StructureViewPanel(structureView);
            }
            this.viewManager = new BrowserViewManager();
            this.optionsFrame = new OptionsFrame(iconRegistry);
            this.initialized = true;
        }
        catch (Throwable t) {
            Ajde.getDefault().getErrorHandler().handleError("AJDE failed to initialize.", t);
        }
    }

    public static AjdeUIManager getDefault() {
        return INSTANCE;
    }

    public BrowserViewManager getViewManager() {
        return this.viewManager;
    }

    public Frame getRootFrame() {
        return this.rootFrame;
    }

    public OptionsFrame getOptionsFrame() {
        return this.optionsFrame;
    }

    public void showOptionsFrame() {
        int x = this.rootFrame.getWidth() / 2 + this.rootFrame.getX() - this.optionsFrame.getWidth() / 2;
        int y = this.rootFrame.getHeight() / 2 + this.rootFrame.getY() - this.optionsFrame.getHeight() / 2;
        ((Component)this.optionsFrame).setLocation(x, y);
        ((Component)this.optionsFrame).setVisible(true);
    }

    public AjcBuildOptions getBuildOptions() {
        return this.buildOptionsAdapter;
    }

    public IdeUIAdapter getIdeUIAdapter() {
        return this.ideUIAdapter;
    }

    public TreeViewBuildConfigEditor getBuildConfigEditor() {
        return this.buildConfigEditor;
    }

    public StructureViewPanel getFileStructurePanel() {
        return this.fileStructurePanel;
    }

    public IconRegistry getIconRegistry() {
        return this.iconRegistry;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

