/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodHandle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.util.AbstractVisitor;
import org.objectweb.asm.util.TraceAbstractVisitor;
import org.objectweb.asm.util.TraceAnnotationVisitor;
import org.objectweb.asm.util.TraceSignatureVisitor;
import org.objectweb.asm.util.Traceable;

public class TraceMethodVisitor
extends TraceAbstractVisitor
implements MethodVisitor {
    protected MethodVisitor mv;
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    protected final Map labelNames = new HashMap();

    public TraceMethodVisitor() {
        this(null);
    }

    public TraceMethodVisitor(MethodVisitor methodVisitor) {
        this.mv = methodVisitor;
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(string, bl);
        if (this.mv != null) {
            ((TraceAnnotationVisitor)annotationVisitor).av = this.mv.visitAnnotation(string, bl);
        }
        return annotationVisitor;
    }

    public void visitAttribute(Attribute attribute) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        if (attribute instanceof Traceable) {
            ((Traceable)attribute).trace(this.buf, this.labelNames);
        } else {
            this.buf.append(" : unknown\n");
        }
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitAttribute(attribute);
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.text.add(this.tab2 + "default=");
        TraceAnnotationVisitor traceAnnotationVisitor = this.createTraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add("\n");
        if (this.mv != null) {
            traceAnnotationVisitor.av = this.mv.visitAnnotationDefault();
        }
        return traceAnnotationVisitor;
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append('@');
        this.appendDescriptor(1, string);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor traceAnnotationVisitor = this.createTraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add(bl ? ") // parameter " : ") // invisible, parameter ");
        this.text.add(new Integer(n));
        this.text.add("\n");
        if (this.mv != null) {
            traceAnnotationVisitor.av = this.mv.visitParameterAnnotation(n, string, bl);
        }
        return traceAnnotationVisitor;
    }

    public void visitCode() {
        if (this.mv != null) {
            this.mv.visitCode();
        }
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.buf.append("FRAME ");
        switch (n) {
            case -1: 
            case 0: {
                this.buf.append("FULL [");
                this.appendFrameTypes(n2, objectArray);
                this.buf.append("] [");
                this.appendFrameTypes(n3, objectArray2);
                this.buf.append(']');
                break;
            }
            case 1: {
                this.buf.append("APPEND [");
                this.appendFrameTypes(n2, objectArray);
                this.buf.append(']');
                break;
            }
            case 2: {
                this.buf.append("CHOP ").append(n2);
                break;
            }
            case 3: {
                this.buf.append("SAME");
                break;
            }
            case 4: {
                this.buf.append("SAME1 ");
                this.appendFrameTypes(1, objectArray2);
            }
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitFrame(n, n2, objectArray, n3, objectArray2);
        }
    }

    public void visitInsn(int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitInsn(n);
        }
    }

    public void visitIntInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ').append(n == 188 ? TYPES[n2] : Integer.toString(n2)).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitIntInsn(n, n2);
        }
    }

    public void visitVarInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ').append(n2).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitVarInsn(n, n2);
        }
    }

    public void visitTypeInsn(int n, String string) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendDescriptor(0, string);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTypeInsn(n, string);
        }
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendDescriptor(0, string);
        this.buf.append('.').append(string2).append(" : ");
        this.appendDescriptor(1, string3);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitFieldInsn(n, string, string2, string3);
        }
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendDescriptor(0, string);
        this.buf.append('.').append(string2).append(' ');
        this.appendDescriptor(3, string3);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMethodInsn(n, string, string2, string3);
        }
    }

    public void visitInvokeDynamicInsn(String string, String string2, MethodHandle methodHandle, Object ... objectArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("INVOKEDYNAMIC").append(' ');
        this.buf.append(string).append(' ');
        this.appendDescriptor(3, string2);
        this.buf.append(" [").append(methodHandle).append(", ");
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof String) {
                AbstractVisitor.appendString(this.buf, (String)object);
            } else if (object instanceof Type) {
                this.buf.append(((Type)object).getDescriptor()).append(".class");
            } else {
                this.buf.append(object);
            }
            this.buf.append(", ");
        }
        this.buf.setLength(this.buf.length() - 2);
        this.buf.append("]\n");
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitInvokeDynamicInsn(string, string2, methodHandle, objectArray);
        }
    }

    public void visitJumpInsn(int n, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append(OPCODES[n]).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitJumpInsn(n, label);
        }
    }

    public void visitLabel(Label label) {
        this.buf.setLength(0);
        this.buf.append(this.ltab);
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLabel(label);
        }
    }

    public void visitLdcInsn(Object object) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LDC ");
        if (object instanceof String) {
            AbstractVisitor.appendString(this.buf, (String)object);
        } else if (object instanceof Type) {
            this.buf.append(((Type)object).getDescriptor()).append(".class");
        } else {
            this.buf.append(object);
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLdcInsn(object);
        }
    }

    public void visitIincInsn(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("IINC ").append(n).append(' ').append(n2).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitIincInsn(n, n2);
        }
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TABLESWITCH\n");
        for (int i = 0; i < labelArray.length; ++i) {
            this.buf.append(this.tab3).append(n + i).append(": ");
            this.appendLabel(labelArray[i]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTableSwitchInsn(n, n2, label, labelArray);
        }
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOOKUPSWITCH\n");
        for (int i = 0; i < labelArray.length; ++i) {
            this.buf.append(this.tab3).append(nArray[i]).append(": ");
            this.appendLabel(labelArray[i]);
            this.buf.append('\n');
        }
        this.buf.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLookupSwitchInsn(label, nArray, labelArray);
        }
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MULTIANEWARRAY ");
        this.appendDescriptor(1, string);
        this.buf.append(' ').append(n).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMultiANewArrayInsn(string, n);
        }
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("TRYCATCHBLOCK ");
        this.appendLabel(label);
        this.buf.append(' ');
        this.appendLabel(label2);
        this.buf.append(' ');
        this.appendLabel(label3);
        this.buf.append(' ');
        this.appendDescriptor(0, string);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitTryCatchBlock(label, label2, label3, string);
        }
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LOCALVARIABLE ").append(string).append(' ');
        this.appendDescriptor(1, string2);
        this.buf.append(' ');
        this.appendLabel(label);
        this.buf.append(' ');
        this.appendLabel(label2);
        this.buf.append(' ').append(n).append('\n');
        if (string3 != null) {
            this.buf.append(this.tab2);
            this.appendDescriptor(2, string3);
            TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(0);
            SignatureReader signatureReader = new SignatureReader(string3);
            signatureReader.acceptType((SignatureVisitor)traceSignatureVisitor);
            this.buf.append(this.tab2).append("// declaration: ").append(traceSignatureVisitor.getDeclaration()).append('\n');
        }
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLocalVariable(string, string2, string3, label, label2, n);
        }
    }

    public void visitLineNumber(int n, Label label) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("LINENUMBER ").append(n).append(' ');
        this.appendLabel(label);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitLineNumber(n, label);
        }
    }

    public void visitMaxs(int n, int n2) {
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXSTACK = ").append(n).append('\n');
        this.text.add(this.buf.toString());
        this.buf.setLength(0);
        this.buf.append(this.tab2).append("MAXLOCALS = ").append(n2).append('\n');
        this.text.add(this.buf.toString());
        if (this.mv != null) {
            this.mv.visitMaxs(n, n2);
        }
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.mv != null) {
            this.mv.visitEnd();
        }
    }

    private void appendFrameTypes(int n, Object[] objectArray) {
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.buf.append(' ');
            }
            if (objectArray[i] instanceof String) {
                String string = (String)objectArray[i];
                if (string.startsWith("[")) {
                    this.appendDescriptor(1, string);
                    continue;
                }
                this.appendDescriptor(0, string);
                continue;
            }
            if (objectArray[i] instanceof Integer) {
                switch ((Integer)objectArray[i]) {
                    case 0: {
                        this.appendDescriptor(1, "T");
                        break;
                    }
                    case 1: {
                        this.appendDescriptor(1, "I");
                        break;
                    }
                    case 2: {
                        this.appendDescriptor(1, "F");
                        break;
                    }
                    case 3: {
                        this.appendDescriptor(1, "D");
                        break;
                    }
                    case 4: {
                        this.appendDescriptor(1, "J");
                        break;
                    }
                    case 5: {
                        this.appendDescriptor(1, "N");
                        break;
                    }
                    case 6: {
                        this.appendDescriptor(1, "U");
                    }
                }
                continue;
            }
            this.appendLabel((Label)objectArray[i]);
        }
    }

    protected void appendLabel(Label label) {
        String string = (String)this.labelNames.get(label);
        if (string == null) {
            string = "L" + this.labelNames.size();
            this.labelNames.put(label, string);
        }
        this.buf.append(string);
    }
}

