/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassNode {
    public int version;
    public int access;
    public String name;
    public String superName;
    public final List interfaces;
    public String sourceFile;
    public final List innerClasses;
    public final List fields;
    public final List methods;
    public Attribute attrs;

    public ClassNode(int n, int n2, String string, String string2, String[] stringArray, String string3) {
        this.version = n;
        this.access = n2;
        this.name = string;
        this.superName = string2;
        this.interfaces = new ArrayList();
        this.sourceFile = string3;
        this.innerClasses = new ArrayList();
        this.fields = new ArrayList();
        this.methods = new ArrayList();
        if (stringArray != null) {
            this.interfaces.addAll(Arrays.asList(stringArray));
        }
    }

    public void accept(ClassVisitor classVisitor) {
        int n;
        String[] stringArray = new String[this.interfaces.size()];
        this.interfaces.toArray(stringArray);
        classVisitor.visit(this.version, this.access, this.name, this.superName, stringArray, this.sourceFile);
        for (n = 0; n < this.innerClasses.size(); ++n) {
            ((InnerClassNode)this.innerClasses.get(n)).accept(classVisitor);
        }
        for (n = 0; n < this.fields.size(); ++n) {
            ((FieldNode)this.fields.get(n)).accept(classVisitor);
        }
        for (n = 0; n < this.methods.size(); ++n) {
            ((MethodNode)this.methods.get(n)).accept(classVisitor);
        }
        Attribute attribute = this.attrs;
        while (attribute != null) {
            classVisitor.visitAttribute(attribute);
            attribute = attribute.next;
        }
        classVisitor.visitEnd();
    }
}

