/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassNode {
    public int access;
    public String name;
    public String superName;
    public final List interfaces;
    public String sourceFile;
    public final List innerClasses;
    public final List fields;
    public final List methods;

    public ClassNode(int n, String string, String string2, String[] stringArray, String string3) {
        this.access = n;
        this.name = string;
        this.superName = string2;
        this.interfaces = new ArrayList();
        this.sourceFile = string3;
        this.innerClasses = new ArrayList();
        this.fields = new ArrayList();
        this.methods = new ArrayList();
        if (stringArray != null) {
            this.interfaces.addAll(Arrays.asList(stringArray));
        }
    }

    public void accept(ClassVisitor classVisitor) {
        String[] stringArray = new String[this.interfaces.size()];
        this.interfaces.toArray(stringArray);
        classVisitor.visit(this.access, this.name, this.superName, stringArray, this.sourceFile);
        int n = 0;
        while (n < this.innerClasses.size()) {
            ((InnerClassNode)this.innerClasses.get(n)).accept(classVisitor);
            ++n;
        }
        n = 0;
        while (n < this.fields.size()) {
            ((FieldNode)this.fields.get(n)).accept(classVisitor);
            ++n;
        }
        n = 0;
        while (n < this.methods.size()) {
            ((MethodNode)this.methods.get(n)).accept(classVisitor);
            ++n;
        }
        classVisitor.visitEnd();
    }
}

