/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.attrs.StackMapType;

public class StackMapFrame {
    public Label label;
    public List locals = new LinkedList();
    public List stack = new LinkedList();

    public int read(ClassReader classReader, int n, char[] cArray, int n2, Label[] labelArray) {
        int n3 = classReader.readUnsignedShort(n);
        n += 2;
        if (labelArray[n3] == null) {
            labelArray[n3] = new Label();
        }
        this.label = labelArray[n3];
        n = this.readTypeInfo(classReader, n, this.locals, labelArray, cArray, classReader.readUnsignedShort(n2 + 2));
        n = this.readTypeInfo(classReader, n, this.stack, labelArray, cArray, classReader.readUnsignedShort(n2));
        return n;
    }

    public void write(ClassWriter classWriter, int n, int n2, ByteVector byteVector) {
        byteVector.putShort(this.label.getOffset());
        this.writeTypeInfo(byteVector, classWriter, this.locals, n2);
        this.writeTypeInfo(byteVector, classWriter, this.stack, n);
    }

    public void getLabels(Set set) {
        set.add(this.label);
        this.getTypeInfoLabels(set, this.locals);
        this.getTypeInfoLabels(set, this.stack);
    }

    private void getTypeInfoLabels(Set set, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StackMapType stackMapType = (StackMapType)iterator.next();
            if (stackMapType.getType() != 8) continue;
            set.add(stackMapType.getLabel());
        }
    }

    private int readTypeInfo(ClassReader classReader, int n, List list, Label[] labelArray, char[] cArray, int n2) {
        int n3 = 0;
        if (n2 > 65535) {
            n3 = classReader.readInt(n);
            n += 4;
        } else {
            n3 = classReader.readUnsignedShort(n);
            n += 2;
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = classReader.readByte(n++);
            StackMapType stackMapType = StackMapType.getTypeInfo(n5);
            list.add(stackMapType);
            switch (n5) {
                case 3: 
                case 4: {
                    list.add(StackMapType.getTypeInfo(0));
                    break;
                }
                case 7: {
                    stackMapType.setObject(classReader.readClass(n, cArray));
                    n += 2;
                    break;
                }
                case 8: {
                    int n6 = classReader.readUnsignedShort(n);
                    n += 2;
                    if (labelArray[n6] == null) {
                        labelArray[n6] = new Label();
                    }
                    stackMapType.setLabel(labelArray[n6]);
                }
            }
            ++n4;
        }
        return n;
    }

    private void writeTypeInfo(ByteVector byteVector, ClassWriter classWriter, List list, int n) {
        if (n > 65535) {
            byteVector.putInt(list.size());
        } else {
            byteVector.putShort(list.size());
        }
        int n2 = 0;
        while (n2 < list.size()) {
            StackMapType stackMapType = (StackMapType)list.get(n2);
            byteVector = new ByteVector().putByte(stackMapType.getType());
            switch (stackMapType.getType()) {
                case 3: 
                case 4: {
                    ++n2;
                    break;
                }
                case 7: {
                    byteVector.putShort(classWriter.newClass(stackMapType.getObject()));
                    break;
                }
                case 8: {
                    byteVector.putShort(stackMapType.getLabel().getOffset());
                }
            }
            ++n2;
        }
    }

    public void dump(StringBuffer stringBuffer, String string, Map map) {
        StackMapFrame.declareLabel(stringBuffer, map, this.label);
        stringBuffer.append(string).append(".label = ").append(map.get(this.label)).append(";\n");
        this.dumpTypeInfo(stringBuffer, string, map, this.locals);
        this.dumpTypeInfo(stringBuffer, string, map, this.stack);
    }

    private void dumpTypeInfo(StringBuffer stringBuffer, String string, Map map, List list) {
        if (list.size() > 0) {
            stringBuffer.append("{\n");
            int n = 0;
            while (n < list.size()) {
                StackMapType stackMapType = (StackMapType)list.get(n);
                String string2 = string + "Info" + n;
                int n2 = stackMapType.getType();
                stringBuffer.append("StackMapType ").append(string2).append(" = new StackMapType( StackMapType.ITEM_").append(StackMapType.ITEM_NAMES[n2]).append(");\n");
                switch (n2) {
                    case 7: {
                        stringBuffer.append(string2).append(".setObject(").append(stackMapType.getObject()).append(");\n");
                        break;
                    }
                    case 8: {
                        StackMapFrame.declareLabel(stringBuffer, map, stackMapType.getLabel());
                        stringBuffer.append(string2).append(".setLabel(").append(map.get(stackMapType.getLabel())).append(");\n");
                    }
                }
                stringBuffer.append(string).append(".add(").append(string2).append(");\n");
                ++n;
            }
            stringBuffer.append("}\n");
        }
    }

    public static void declareLabel(StringBuffer stringBuffer, Map map, Label label) {
        String string = (String)map.get(label);
        if (string == null) {
            string = "l" + map.size();
            map.put(label, string);
            stringBuffer.append("Label ").append(string).append(" = new Label();\n");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Frame:L");
        stringBuffer.append(System.identityHashCode(this.label));
        stringBuffer.append(" locals").append(this.locals);
        stringBuffer.append(" stack").append(this.stack);
        return stringBuffer.toString();
    }
}

