/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import java.util.Map;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.attrs.Dumpable;

public class SourceDebugExtensionAttribute
extends Attribute
implements Dumpable {
    public String debugExtension;

    public SourceDebugExtensionAttribute() {
        super("SourceDebugExtension");
    }

    public SourceDebugExtensionAttribute(String string) {
        this();
        this.debugExtension = string;
    }

    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        return new SourceDebugExtensionAttribute(this.readUTF8(classReader, n, n2));
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = this.putUTF8(this.debugExtension);
        return new ByteVector().putByteArray(byArray2, 0, byArray2.length);
    }

    public void dump(StringBuffer stringBuffer, String string, Map map) {
        stringBuffer.append("SourceDebugExtensionAttribute ").append(string).append(" = new SourceDebugExtensionAttribute(\"").append(this.debugExtension).append("\");\n");
    }

    private String readUTF8(ClassReader classReader, int n, int n2) {
        int n3 = n + n2;
        byte[] byArray = classReader.b;
        char[] cArray = new char[n2];
        int n4 = 0;
        while (n < n3) {
            int n5 = byArray[n++] & 0xFF;
            switch (n5 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n4++] = (char)n5;
                    break;
                }
                case 12: 
                case 13: {
                    byte by = byArray[n++];
                    cArray[n4++] = (char)((n5 & 0x1F) << 6 | by & 0x3F);
                    break;
                }
                default: {
                    byte by = byArray[n++];
                    byte by2 = byArray[n++];
                    cArray[n4++] = (char)((n5 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                }
            }
        }
        return new String(cArray, 0, n4);
    }

    private byte[] putUTF8(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n3;
        }
        byte[] byArray = new byte[n2];
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n4++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                byArray[n4++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byArray[n4++] = (byte)(0xC0 | c >> 6 & 0x1F);
            byArray[n4++] = (byte)(0x80 | c & 0x3F);
        }
        return byArray;
    }

    public String toString() {
        return this.debugExtension;
    }
}

