/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.server.listener.version;

import asia.stampy.client.message.connect.ConnectHeader;
import asia.stampy.client.message.connect.ConnectMessage;
import asia.stampy.client.message.stomp.StompMessage;
import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.StampyMessageListener;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.server.listener.version.StompVersionException;
import java.lang.invoke.MethodHandles;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Resource
@StampyLibrary(libraryName="stampy-client-server")
public class VersionListener
implements StampyMessageListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static StompMessageType[] TYPES = new StompMessageType[]{StompMessageType.CONNECT, StompMessageType.STOMP};
    private static final String VERSION = "1.2";

    @Override
    public StompMessageType[] getMessageTypes() {
        return TYPES;
    }

    @Override
    public boolean isForMessage(StampyMessage<?> message) {
        return true;
    }

    @Override
    public void messageReceived(StampyMessage<?> message, HostPort hostPort) throws Exception {
        switch (message.getMessageType()) {
            case CONNECT: {
                this.checkVersion(hostPort, (ConnectHeader)((ConnectMessage)message).getHeader());
                break;
            }
            case STOMP: {
                this.checkVersion(hostPort, (ConnectHeader)((StompMessage)message).getHeader());
                break;
            }
        }
    }

    private void checkVersion(HostPort hostPort, ConnectHeader header) throws StompVersionException {
        String[] parts;
        String acceptVersion = header.getAcceptVersion();
        for (String part : parts = acceptVersion.split(",")) {
            if (!part.trim().equals(VERSION)) continue;
            log.info("Accept version is valid for {}", (Object)hostPort);
            return;
        }
        throw new StompVersionException("Only STOMP version 1.2 is supported");
    }
}

