/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.server.listener.transaction;

import asia.stampy.client.message.abort.AbortHeader;
import asia.stampy.client.message.abort.AbortMessage;
import asia.stampy.client.message.begin.BeginHeader;
import asia.stampy.client.message.begin.BeginMessage;
import asia.stampy.client.message.commit.CommitHeader;
import asia.stampy.client.message.commit.CommitMessage;
import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.StampyMessageListener;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.server.listener.transaction.TransactionAlreadyStartedException;
import asia.stampy.server.listener.transaction.TransactionNotStartedException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-client-server")
public abstract class AbstractTransactionListener<SVR extends AbstractStampyMessageGateway>
implements StampyMessageListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Map<HostPort, Queue<String>> activeTransactions = new ConcurrentHashMap<HostPort, Queue<String>>();
    private SVR gateway;
    private static StompMessageType[] TYPES = new StompMessageType[]{StompMessageType.ABORT, StompMessageType.BEGIN, StompMessageType.COMMIT, StompMessageType.DISCONNECT};

    @Override
    public StompMessageType[] getMessageTypes() {
        return TYPES;
    }

    @Override
    public boolean isForMessage(StampyMessage<?> message) {
        return true;
    }

    @Override
    public void messageReceived(StampyMessage<?> message, HostPort hostPort) throws Exception {
        switch (message.getMessageType()) {
            case ABORT: {
                this.abort(hostPort, ((AbortHeader)((AbortMessage)message).getHeader()).getTransaction());
                break;
            }
            case BEGIN: {
                this.begin(hostPort, ((BeginHeader)((BeginMessage)message).getHeader()).getTransaction());
                break;
            }
            case COMMIT: {
                this.commit(hostPort, ((CommitHeader)((CommitMessage)message).getHeader()).getTransaction());
                break;
            }
            case DISCONNECT: {
                this.logOutstandingTransactions(hostPort);
                break;
            }
        }
    }

    private void logOutstandingTransactions(HostPort hostPort) {
        Queue<String> q = this.getTransactions(hostPort);
        if (q.isEmpty()) {
            return;
        }
        for (String transaction : q) {
            log.warn("Disconnect received, discarding outstanding transaction {}", (Object)transaction);
        }
    }

    private void commit(HostPort hostPort, String transaction) throws TransactionNotStartedException {
        this.removeActiveTransaction(hostPort, transaction, "committed");
    }

    private void abort(HostPort hostPort, String transaction) throws TransactionNotStartedException {
        this.removeActiveTransaction(hostPort, transaction, "aborted");
    }

    private void begin(HostPort hostPort, String transaction) throws TransactionAlreadyStartedException {
        if (this.isNoTransaction(hostPort, transaction)) {
            log.info("Starting transaction {} for {}", (Object)transaction, (Object)hostPort);
            Queue<String> q = this.getTransactions(hostPort);
            q.add(transaction);
        }
    }

    private boolean isNoTransaction(HostPort hostPort, String transaction) throws TransactionAlreadyStartedException {
        Queue<String> q = this.getTransactions(hostPort);
        if (q.contains(transaction)) {
            String error = "Transaction already started";
            throw new TransactionAlreadyStartedException(error);
        }
        return true;
    }

    private void removeActiveTransaction(HostPort hostPort, String transaction, String function) throws TransactionNotStartedException {
        if (this.isTransactionStarted(hostPort, transaction)) {
            Object[] parms = new Object[]{transaction, hostPort, function};
            log.info("Transaction id {} for {} {}", parms);
            Queue<String> q = this.getTransactions(hostPort);
            q.remove(transaction);
        }
    }

    private Queue<String> getTransactions(HostPort hostPort) {
        Queue<String> transactions = this.activeTransactions.get(hostPort);
        if (transactions == null) {
            transactions = new ConcurrentLinkedQueue<String>();
            this.activeTransactions.put(hostPort, transactions);
        }
        return transactions;
    }

    private boolean isTransactionStarted(HostPort hostPort, String transaction) throws TransactionNotStartedException {
        Queue<String> q = this.getTransactions(hostPort);
        if (!q.contains(transaction)) {
            String error = "Transaction not started";
            log.error(error);
            throw new TransactionNotStartedException(error);
        }
        return true;
    }

    public SVR getGateway() {
        return this.gateway;
    }

    public void setGateway(SVR gateway) {
        this.gateway = gateway;
    }

    protected abstract void ensureCleanup();
}

