/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.server.listener.receipt;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.StampyMessageListener;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.server.message.receipt.ReceiptMessage;
import java.lang.invoke.MethodHandles;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-client-server")
public abstract class AbstractReceiptListener<SVR extends AbstractStampyMessageGateway>
implements StampyMessageListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static StompMessageType[] TYPES = new StompMessageType[]{StompMessageType.ABORT, StompMessageType.ACK, StompMessageType.BEGIN, StompMessageType.COMMIT, StompMessageType.DISCONNECT, StompMessageType.NACK, StompMessageType.SEND, StompMessageType.SUBSCRIBE, StompMessageType.UNSUBSCRIBE};
    private SVR gateway;

    @Override
    public StompMessageType[] getMessageTypes() {
        return TYPES;
    }

    @Override
    public boolean isForMessage(StampyMessage<?> message) {
        String receipt = this.getReceipt(message);
        return StringUtils.isNotEmpty((String)receipt);
    }

    @Override
    public void messageReceived(StampyMessage<?> message, HostPort hostPort) throws Exception {
        ReceiptMessage msg = new ReceiptMessage(this.getReceipt(message));
        ((AbstractStampyMessageGateway)this.getGateway()).sendMessage((StampyMessage<?>)msg, hostPort);
        log.debug("Sent RECEIPT message to {}", (Object)hostPort);
    }

    private String getReceipt(StampyMessage<?> message) {
        return message.getHeader().getHeaderValue("receipt");
    }

    public SVR getGateway() {
        return this.gateway;
    }

    public void setGateway(SVR gateway) {
        this.gateway = gateway;
    }
}

