/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.server.listener.login;

import asia.stampy.client.message.connect.ConnectHeader;
import asia.stampy.client.message.connect.ConnectMessage;
import asia.stampy.client.message.stomp.StompMessage;
import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.MessageListenerHaltException;
import asia.stampy.common.gateway.StampyMessageListener;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.common.message.interceptor.InterceptException;
import asia.stampy.server.listener.login.AlreadyLoggedInException;
import asia.stampy.server.listener.login.NotLoggedInException;
import asia.stampy.server.listener.login.StampyLoginHandler;
import asia.stampy.server.listener.login.TerminateSessionException;
import asia.stampy.server.message.error.ErrorHeader;
import asia.stampy.server.message.error.ErrorMessage;
import java.lang.invoke.MethodHandles;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-client-server")
public abstract class AbstractLoginMessageListener<SVR extends AbstractStampyMessageGateway>
implements StampyMessageListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static StompMessageType[] TYPES = StompMessageType.values();
    protected Queue<HostPort> loggedInConnections = new ConcurrentLinkedQueue<HostPort>();
    private StampyLoginHandler loginHandler;
    private SVR gateway;

    @Override
    public StompMessageType[] getMessageTypes() {
        return TYPES;
    }

    @Override
    public boolean isForMessage(StampyMessage<?> message) {
        return true;
    }

    @Override
    public void messageReceived(StampyMessage<?> message, HostPort hostPort) throws Exception {
        switch (message.getMessageType()) {
            case ABORT: 
            case ACK: 
            case BEGIN: 
            case COMMIT: 
            case NACK: 
            case SEND: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                this.loggedInCheck(message, hostPort);
                break;
            }
            case CONNECT: {
                this.logIn(hostPort, (ConnectHeader)((ConnectMessage)message).getHeader());
                break;
            }
            case STOMP: {
                this.logIn(hostPort, (ConnectHeader)((StompMessage)message).getHeader());
                break;
            }
            case DISCONNECT: {
                this.loggedInConnections.remove(hostPort);
                break;
            }
            default: {
                String error = "Unexpected message type " + message.getMessageType();
                log.error(error);
                throw new IllegalArgumentException(error);
            }
        }
    }

    private void loggedInCheck(StampyMessage<?> message, HostPort hostPort) throws NotLoggedInException {
        if (this.loggedInConnections.contains(hostPort)) {
            return;
        }
        log.error("{} attempted to send a {} message without logging in", (Object)hostPort, (Object)message.getMessageType());
        throw new NotLoggedInException("Not logged in");
    }

    private void logIn(HostPort hostPort, ConnectHeader header) throws AlreadyLoggedInException, NotLoggedInException, MessageListenerHaltException {
        if (this.loggedInConnections.contains(hostPort)) {
            throw new AlreadyLoggedInException(hostPort + " is already logged in");
        }
        if (!this.isForHeader(header)) {
            throw new NotLoggedInException("login and passcode not specified, cannot log in");
        }
        try {
            this.getLoginHandler().login(header.getLogin(), header.getPasscode());
            this.loggedInConnections.add(hostPort);
        }
        catch (TerminateSessionException e) {
            log.error("Login handler has terminated the session", (Throwable)e);
            this.sendErrorMessage(e.getMessage(), hostPort);
            ((AbstractStampyMessageGateway)this.gateway).closeConnection(hostPort);
            throw new MessageListenerHaltException();
        }
    }

    private void sendErrorMessage(String message, HostPort hostPort) {
        ErrorMessage error = new ErrorMessage("n/a");
        ((ErrorHeader)error.getHeader()).setMessageHeader(message);
        try {
            ((AbstractStampyMessageGateway)this.getGateway()).sendMessage((StampyMessage<?>)error, hostPort);
        }
        catch (InterceptException e) {
            log.error("Sending of login error message failed", (Throwable)e);
        }
    }

    private boolean isForHeader(ConnectHeader header) {
        return StringUtils.isNotEmpty((String)header.getLogin()) && StringUtils.isNotEmpty((String)header.getPasscode());
    }

    public StampyLoginHandler getLoginHandler() {
        return this.loginHandler;
    }

    public void setLoginHandler(StampyLoginHandler loginHandler) {
        this.loginHandler = loginHandler;
    }

    public SVR getGateway() {
        return this.gateway;
    }

    public void setGateway(SVR gateway) {
        this.gateway = gateway;
        this.ensureCleanup();
    }

    protected abstract void ensureCleanup();
}

