/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.server.listener.heartbeat;

import asia.stampy.client.message.connect.ConnectHeader;
import asia.stampy.client.message.connect.ConnectMessage;
import asia.stampy.client.message.stomp.StompMessage;
import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.StampyMessageListener;
import asia.stampy.common.heartbeat.StampyHeartbeatContainer;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import java.lang.invoke.MethodHandles;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-client-server")
public abstract class AbstractHeartbeatListener<SVR extends AbstractStampyMessageGateway>
implements StampyMessageListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static StompMessageType[] TYPES = new StompMessageType[]{StompMessageType.CONNECT, StompMessageType.STOMP, StompMessageType.DISCONNECT};
    private StampyHeartbeatContainer heartbeatContainer;
    private SVR gateway;

    @Override
    public StompMessageType[] getMessageTypes() {
        return TYPES;
    }

    @Override
    public boolean isForMessage(StampyMessage<?> message) {
        return StringUtils.isNotEmpty((String)message.getHeader().getHeaderValue("heart-beat")) || this.isDisconnectMessage(message);
    }

    @Override
    public void messageReceived(StampyMessage<?> message, HostPort hostPort) throws Exception {
        if (this.isDisconnectMessage(message)) {
            this.getHeartbeatContainer().remove(hostPort);
            return;
        }
        ConnectHeader header = this.getConnectHeader(message);
        int requested = header.getIncomingHeartbeat();
        if (((AbstractStampyMessageGateway)this.getGateway()).getHeartbeat() <= 0 || requested <= 0) {
            return;
        }
        int heartbeat = Math.max(requested, ((AbstractStampyMessageGateway)this.getGateway()).getHeartbeat());
        log.info("Starting heartbeats for {} at {} ms intervals", (Object)hostPort, (Object)heartbeat);
        this.getHeartbeatContainer().start(hostPort, (AbstractStampyMessageGateway)this.getGateway(), heartbeat);
    }

    public void resetHeartbeat(HostPort hostPort) {
        this.getHeartbeatContainer().reset(hostPort);
    }

    private ConnectHeader getConnectHeader(StampyMessage<?> message) {
        return this.isConnectMessage(message) ? (ConnectHeader)((ConnectMessage)message).getHeader() : (ConnectHeader)((StompMessage)message).getHeader();
    }

    private boolean isConnectMessage(StampyMessage<?> message) {
        return StompMessageType.CONNECT.equals((Object)message.getMessageType());
    }

    private boolean isDisconnectMessage(StampyMessage<?> message) {
        return StompMessageType.DISCONNECT.equals((Object)message.getMessageType());
    }

    public StampyHeartbeatContainer getHeartbeatContainer() {
        return this.heartbeatContainer;
    }

    public void setHeartbeatContainer(StampyHeartbeatContainer heartbeatContainer) {
        this.heartbeatContainer = heartbeatContainer;
    }

    public SVR getGateway() {
        return this.gateway;
    }

    public void setGateway(SVR gateway) {
        this.gateway = gateway;
    }
}

