/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.server.listener.connect;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.StampyMessageListener;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.server.listener.connect.AlreadyConnectedException;
import asia.stampy.server.listener.connect.NotConnectedException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-client-server")
public abstract class AbstractConnectStateListener<SVR extends AbstractStampyMessageGateway>
implements StampyMessageListener {
    protected Queue<HostPort> connectedClients = new ConcurrentLinkedQueue<HostPort>();
    private SVR gateway;
    private static StompMessageType[] TYPES = StompMessageType.values();

    @Override
    public StompMessageType[] getMessageTypes() {
        return TYPES;
    }

    @Override
    public boolean isForMessage(StampyMessage<?> message) {
        return true;
    }

    @Override
    public void messageReceived(StampyMessage<?> message, HostPort hostPort) throws Exception {
        switch (message.getMessageType()) {
            case ABORT: 
            case ACK: 
            case BEGIN: 
            case COMMIT: 
            case NACK: 
            case SEND: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: {
                this.checkConnected(hostPort);
                break;
            }
            case CONNECT: 
            case STOMP: {
                this.checkDisconnected(hostPort);
                this.connectedClients.add(hostPort);
                break;
            }
            case DISCONNECT: {
                this.connectedClients.remove(hostPort);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected message type " + message.getMessageType());
            }
        }
    }

    private void checkDisconnected(HostPort hostPort) throws AlreadyConnectedException {
        if (!this.connectedClients.contains(hostPort)) {
            return;
        }
        throw new AlreadyConnectedException(hostPort + " is already connected");
    }

    private void checkConnected(HostPort hostPort) throws NotConnectedException {
        if (this.connectedClients.contains(hostPort)) {
            return;
        }
        throw new NotConnectedException("CONNECT message required for " + hostPort);
    }

    public SVR getGateway() {
        return this.gateway;
    }

    public void setGateway(SVR gateway) {
        this.gateway = gateway;
        this.ensureCleanup();
    }

    protected abstract void ensureCleanup();
}

