/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.server.listener.connect;

import asia.stampy.client.message.connect.ConnectHeader;
import asia.stampy.client.message.connect.ConnectMessage;
import asia.stampy.client.message.stomp.StompMessage;
import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.StampyMessageListener;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.common.message.interceptor.InterceptException;
import asia.stampy.server.message.connected.ConnectedHeader;
import asia.stampy.server.message.connected.ConnectedMessage;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-client-server")
public abstract class AbstractConnectResponseListener<SVR extends AbstractStampyMessageGateway>
implements StampyMessageListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static StompMessageType[] TYPES = new StompMessageType[]{StompMessageType.CONNECT, StompMessageType.STOMP};
    private SVR gateway;

    @Override
    public StompMessageType[] getMessageTypes() {
        return TYPES;
    }

    @Override
    public boolean isForMessage(StampyMessage<?> message) {
        return true;
    }

    @Override
    public void messageReceived(StampyMessage<?> message, HostPort hostPort) throws Exception {
        switch (message.getMessageType()) {
            case CONNECT: {
                this.sendConnected((ConnectHeader)((ConnectMessage)message).getHeader(), hostPort);
                return;
            }
            case STOMP: {
                this.sendConnected((ConnectHeader)((StompMessage)message).getHeader(), hostPort);
                return;
            }
        }
    }

    private void sendConnected(ConnectHeader header, HostPort hostPort) throws InterceptException {
        log.debug("Sending connected message to {}", (Object)hostPort);
        ConnectedMessage message = new ConnectedMessage("1.2");
        int requested = ((ConnectedHeader)message.getHeader()).getIncomingHeartbeat();
        if (requested >= 0 || ((AbstractStampyMessageGateway)this.getGateway()).getHeartbeat() >= 0) {
            int heartbeat = Math.max(requested, ((AbstractStampyMessageGateway)this.getGateway()).getHeartbeat());
            ((ConnectedHeader)message.getHeader()).setHeartbeat(heartbeat, header.getOutgoingHeartbeat());
        }
        ((ConnectedHeader)message.getHeader()).setSession(hostPort.toString());
        ((AbstractStampyMessageGateway)this.getGateway()).sendMessage((StampyMessage<?>)message, hostPort);
        log.debug("Sent connected message to {}", (Object)hostPort);
    }

    public SVR getGateway() {
        return this.gateway;
    }

    public void setGateway(SVR gateway) {
        this.gateway = gateway;
    }
}

