/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.heartbeat;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.HostPort;
import java.lang.invoke.MethodHandles;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StampyLibrary(libraryName="stampy-client-server")
class PaceMaker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private long timeInMillis;
    private TimerTask stopwatch;
    private Timer timer = new Timer("Stampy PaceMaker", true);
    private AbstractStampyMessageGateway gateway;
    private HostPort hostPort;
    private int heartbeatCount;

    public PaceMaker(int timeInMillis) {
        this.timeInMillis = timeInMillis;
    }

    public synchronized void reset() {
        log.trace("PaceMaker reset invoked");
        this.setHeartbeatCount(0);
        this.stop();
        this.start();
    }

    public void stop() {
        log.trace("PaceMaker stop invoked");
        if (this.stopwatch != null) {
            this.stopwatch.cancel();
            this.timer.purge();
        }
    }

    public void start() {
        log.trace("PaceMaker start invoked for sleep time of {} ms", (Object)this.getSleepTime());
        this.stopwatch = new TimerTask(){

            public void run() {
                PaceMaker.this.executeHeartbeat();
            }
        };
        this.timer.schedule(this.stopwatch, this.getSleepTime());
    }

    private void executeHeartbeat() {
        if (this.heartbeatCount >= 2) {
            log.warn("No response after 2 heartbeats, closing connection");
            this.gateway.closeConnection(this.getHostPort());
        } else {
            try {
                if (this.gateway.isConnected(this.getHostPort())) {
                    this.gateway.sendMessage("\n", this.getHostPort());
                    log.debug("Sent heartbeat");
                    this.start();
                    ++this.heartbeatCount;
                }
            }
            catch (Exception e) {
                log.error("Could not send heartbeat", (Throwable)e);
            }
        }
    }

    public long getSleepTime() {
        return this.timeInMillis;
    }

    public AbstractStampyMessageGateway getGateway() {
        return this.gateway;
    }

    public void setGateway(AbstractStampyMessageGateway gateway) {
        this.gateway = gateway;
    }

    public HostPort getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(HostPort hostPort) {
        this.hostPort = hostPort;
    }

    public int getHeartbeatCount() {
        return this.heartbeatCount;
    }

    public void setHeartbeatCount(int heartbeatCount) {
        this.heartbeatCount = heartbeatCount;
    }
}

