/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.heartbeat;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.heartbeat.PaceMaker;
import asia.stampy.common.heartbeat.StampyHeartbeatContainer;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Resource
@StampyLibrary(libraryName="stampy-client-server")
public class HeartbeatContainer
implements StampyHeartbeatContainer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<HostPort, PaceMaker> paceMakers = new ConcurrentHashMap<HostPort, PaceMaker>();

    public void start(HostPort hostPort, AbstractStampyMessageGateway gateway, int timeMillis) {
        PaceMaker paceMaker = new PaceMaker(timeMillis);
        paceMaker.setHostPort(hostPort);
        paceMaker.setGateway(gateway);
        paceMaker.start();
        this.add(hostPort, paceMaker);
    }

    public void stop(HostPort hostPort) {
        PaceMaker paceMaker = this.paceMakers.get(hostPort);
        if (paceMaker != null) {
            log.info("Stopping PaceMaker for {}", (Object)hostPort);
            paceMaker.stop();
        }
    }

    protected void add(HostPort hostPort, PaceMaker paceMaker) {
        this.stop(hostPort);
        log.info("Adding PaceMaker for {}", (Object)hostPort);
        this.paceMakers.put(hostPort, paceMaker);
    }

    public void remove(HostPort hostPort) {
        this.stop(hostPort);
        log.info("Removing PaceMaker for {}", (Object)hostPort);
        this.paceMakers.remove(hostPort);
    }

    public void reset(HostPort hostPort) {
        if (hostPort == null) {
            return;
        }
        log.trace("Resetting PaceMaker for {}", (Object)hostPort);
        PaceMaker paceMaker = this.paceMakers.get(hostPort);
        if (paceMaker != null) {
            paceMaker.reset();
        }
    }
}

