/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.gateway;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.DefaultUnparseableMessageHandler;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.UnparseableMessageHandler;
import asia.stampy.common.heartbeat.StampyHeartbeatContainer;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.parsing.StompMessageParser;
import asia.stampy.common.parsing.UnparseableException;
import asia.stampy.server.message.error.ErrorHeader;
import asia.stampy.server.message.error.ErrorMessage;
import java.lang.invoke.MethodHandles;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Resource
@StampyLibrary(libraryName="stampy-client-server")
public class StampyHandlerHelper {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private StompMessageParser parser = new StompMessageParser();
    private StampyHeartbeatContainer heartbeatContainer;
    private AbstractStampyMessageGateway gateway;
    private UnparseableMessageHandler unparseableMessageHandler = new DefaultUnparseableMessageHandler();

    public void handleUnexpectedError(HostPort hostPort, String msg, StampyMessage<?> sm, Exception e) {
        try {
            if (sm == null) {
                this.errorHandle(e, hostPort);
            } else {
                this.errorHandle(sm, e, hostPort);
            }
        }
        catch (Exception e1) {
            log.error("Unexpected exception sending error message for " + hostPort, (Throwable)e1);
        }
    }

    public void handleUnparseableMessage(HostPort hostPort, String msg, UnparseableException e) {
        log.debug("Unparseable message, delegating to unparseable message handler");
        try {
            this.getUnparseableMessageHandler().unparseableMessage(msg, hostPort);
        }
        catch (Exception e1) {
            try {
                this.errorHandle(e1, hostPort);
            }
            catch (Exception e2) {
                log.error("Could not parse message " + msg + " for " + hostPort, (Throwable)e);
                log.error("Unexpected exception sending error message for " + hostPort, (Throwable)e2);
            }
        }
    }

    protected void errorHandle(StampyMessage<?> message, Exception e, HostPort hostPort) throws Exception {
        log.error("Handling error, sending error message to " + hostPort, (Throwable)e);
        String receipt = message.getHeader().getHeaderValue("receipt");
        ErrorMessage error = new ErrorMessage(StringUtils.isEmpty((String)receipt) ? "n/a" : receipt);
        ((ErrorHeader)error.getHeader()).setMessageHeader("Could not execute " + message.getMessageType() + " - " + e.getMessage());
        this.getGateway().sendMessage(error.toStompMessage(true), hostPort);
    }

    protected void errorHandle(Exception e, HostPort hostPort) throws Exception {
        log.error("Handling error, sending error message to " + hostPort, (Throwable)e);
        ErrorMessage error = new ErrorMessage("n/a");
        ((ErrorHeader)error.getHeader()).setMessageHeader(e.getMessage());
        this.getGateway().sendMessage(error.toStompMessage(true), hostPort);
    }

    public boolean isHeartbeat(String msg) {
        return msg.equals("\n") || msg.equals("\r\n");
    }

    public boolean isValidObject(Object message) {
        return message instanceof String;
    }

    public void resetHeartbeat(HostPort hostPort) {
        this.getHeartbeatContainer().reset(hostPort);
    }

    public StompMessageParser getParser() {
        return this.parser;
    }

    public void setParser(StompMessageParser parser) {
        this.parser = parser;
    }

    public StampyHeartbeatContainer getHeartbeatContainer() {
        return this.heartbeatContainer;
    }

    public void setHeartbeatContainer(StampyHeartbeatContainer heartbeatContainer) {
        this.heartbeatContainer = heartbeatContainer;
    }

    public AbstractStampyMessageGateway getGateway() {
        return this.gateway;
    }

    public void setGateway(AbstractStampyMessageGateway gateway) {
        this.gateway = gateway;
    }

    public UnparseableMessageHandler getUnparseableMessageHandler() {
        return this.unparseableMessageHandler;
    }

    public void setUnparseableMessageHandler(UnparseableMessageHandler unparseableMessageHandler) {
        this.unparseableMessageHandler = unparseableMessageHandler;
    }
}

