/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.gateway;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.DefaultUnparseableMessageHandler;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.SecurityMessageListener;
import asia.stampy.common.gateway.StampyMessageListener;
import asia.stampy.common.gateway.StampySecurityException;
import asia.stampy.common.gateway.UnparseableMessageHandler;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.common.message.interceptor.InterceptException;
import asia.stampy.common.message.interceptor.StampyOutgoingMessageInterceptor;
import asia.stampy.common.message.interceptor.StampyOutgoingTextInterceptor;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-client-server")
public abstract class AbstractStampyMessageGateway {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Queue<StampyOutgoingMessageInterceptor> interceptors = new ConcurrentLinkedQueue<StampyOutgoingMessageInterceptor>();
    protected Queue<StampyOutgoingTextInterceptor> textInterceptors = new ConcurrentLinkedQueue<StampyOutgoingTextInterceptor>();
    private List<StampyMessageListener> listeners = Collections.synchronizedList(new ArrayList());
    private Lock stampyInterceptorLock = new ReentrantLock(true);
    private Lock textInterceptorLock = new ReentrantLock(true);
    private boolean autoShutdown;
    private int heartbeat;
    private UnparseableMessageHandler unparseableMessageHandler = new DefaultUnparseableMessageHandler();
    private int port;
    private int maxMessageSize = Integer.MAX_VALUE;

    public void broadcastMessage(StampyMessage<?> message) throws InterceptException {
        this.interceptOutgoingMessage(message);
        this.broadcastMessage(message.toStompMessage(true));
    }

    public void addOutgoingMessageInterceptor(StampyOutgoingMessageInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void removeOutgoingMessageInterceptor(StampyOutgoingMessageInterceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    public void setOutgoingMessageInterceptors(Collection<StampyOutgoingMessageInterceptor> interceptors) {
        this.interceptors.addAll(interceptors);
    }

    public void addOutgoingTextInterceptor(StampyOutgoingTextInterceptor interceptor) {
        this.textInterceptors.add(interceptor);
    }

    public void removeOutgoingTextInterceptor(StampyOutgoingTextInterceptor interceptor) {
        this.textInterceptors.remove(interceptor);
    }

    public void setOutgoingTextInterceptors(Collection<StampyOutgoingTextInterceptor> interceptors) {
        this.textInterceptors.addAll(interceptors);
    }

    public void sendMessage(StampyMessage<?> message, HostPort hostPort) throws InterceptException {
        this.interceptOutgoingMessage(message, hostPort);
        this.sendMessage(message.toStompMessage(true), hostPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void interceptOutgoingMessage(StampyMessage<?> message) throws InterceptException {
        this.stampyInterceptorLock.lock();
        try {
            for (StampyOutgoingMessageInterceptor interceptor : this.interceptors) {
                if (!this.isForType(interceptor.getMessageTypes(), message.getMessageType()) || !interceptor.isForMessage(message)) continue;
                interceptor.interceptMessage(message);
            }
        }
        finally {
            this.stampyInterceptorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void interceptOutgoingMessage(StampyMessage<?> message, HostPort hostPort) throws InterceptException {
        this.stampyInterceptorLock.lock();
        try {
            for (StampyOutgoingMessageInterceptor interceptor : this.interceptors) {
                if (!this.isForType(interceptor.getMessageTypes(), message.getMessageType()) || !interceptor.isForMessage(message)) continue;
                interceptor.interceptMessage(message, hostPort);
            }
        }
        finally {
            this.stampyInterceptorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void interceptOutgoingMessage(String message) throws InterceptException {
        this.textInterceptorLock.lock();
        try {
            for (StampyOutgoingTextInterceptor interceptor : this.textInterceptors) {
                interceptor.interceptMessage(message);
            }
        }
        finally {
            this.textInterceptorLock.unlock();
        }
    }

    protected boolean isForType(StompMessageType[] messageTypes, StompMessageType messageType) {
        if (messageTypes == null || messageTypes.length == 0) {
            return false;
        }
        for (StompMessageType type : messageTypes) {
            if (!type.equals((Object)messageType)) continue;
            return true;
        }
        return false;
    }

    public void notifyMessageListeners(StampyMessage<?> sm, HostPort hostPort) throws Exception {
        for (StampyMessageListener listener : this.listeners) {
            if (!this.isForType(listener.getMessageTypes(), sm.getMessageType()) || !listener.isForMessage(sm)) continue;
            log.trace("Evaluating message {} with listener {}", sm, (Object)listener);
            listener.messageReceived(sm, hostPort);
        }
    }

    public final void addMessageListener(StampyMessageListener listener) {
        if (this.listeners.size() == 0 && !(listener instanceof SecurityMessageListener)) {
            throw new StampySecurityException();
        }
        this.listeners.add(listener);
    }

    public final void addMessageListener(StampyMessageListener listener, int idx) {
        if (idx == 0 && !(listener instanceof SecurityMessageListener)) {
            throw new StampySecurityException();
        }
        this.listeners.add(idx, listener);
    }

    public void removeMessageListener(StampyMessageListener listener) {
        this.listeners.remove(listener);
    }

    public void clearMessageListeners() {
        this.listeners.clear();
    }

    public void setListeners(Collection<StampyMessageListener> listeners) {
        this.listeners.addAll(listeners);
    }

    public abstract void broadcastMessage(String var1) throws InterceptException;

    public abstract void sendMessage(String var1, HostPort var2) throws InterceptException;

    public abstract void closeConnection(HostPort var1);

    public abstract void connect() throws Exception;

    public abstract void shutdown() throws Exception;

    public abstract boolean isConnected(HostPort var1);

    public abstract Set<HostPort> getConnectedHostPorts();

    public boolean isAutoShutdown() {
        return this.autoShutdown;
    }

    public void setAutoShutdown(boolean autoShutdown) {
        this.autoShutdown = autoShutdown;
    }

    public int getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
    }

    public UnparseableMessageHandler getUnparseableMessageHandler() {
        return this.unparseableMessageHandler;
    }

    public void setUnparseableMessageHandler(UnparseableMessageHandler unparseableMessageHandler) {
        this.unparseableMessageHandler = unparseableMessageHandler;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }
}

