/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.client.listener.disconnect;

import asia.stampy.client.message.disconnect.DisconnectHeader;
import asia.stampy.client.message.disconnect.DisconnectMessage;
import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.MessageListenerHaltException;
import asia.stampy.common.gateway.StampyMessageListener;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.common.message.interceptor.AbstractOutgoingMessageInterceptor;
import asia.stampy.common.message.interceptor.InterceptException;
import asia.stampy.server.message.receipt.ReceiptHeader;
import asia.stampy.server.message.receipt.ReceiptMessage;
import java.lang.invoke.MethodHandles;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-client-server")
public abstract class AbstractDisconnectListenerAndInterceptor<CLNT extends AbstractStampyMessageGateway>
extends AbstractOutgoingMessageInterceptor<CLNT>
implements StampyMessageListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static StompMessageType[] TYPES = new StompMessageType[]{StompMessageType.DISCONNECT, StompMessageType.RECEIPT};
    private boolean closeOnDisconnectMessage = true;
    private String receiptId;

    @Override
    public StompMessageType[] getMessageTypes() {
        return TYPES;
    }

    @Override
    public boolean isForMessage(StampyMessage<?> message) {
        switch (message.getMessageType()) {
            case DISCONNECT: {
                boolean absent = StringUtils.isEmpty((String)this.getReceiptId());
                if (!absent) {
                    log.warn("Outstanding receipt id {} in DisconnectListenerAndInterceptor, resetting", (Object)this.getReceiptId());
                    this.setReceiptId((String)null);
                }
                return StringUtils.isNotEmpty((String)((DisconnectHeader)((DisconnectMessage)message).getHeader()).getReceipt());
            }
            case RECEIPT: {
                ReceiptMessage receipt = (ReceiptMessage)message;
                return StringUtils.isNotEmpty((String)this.getReceiptId()) && this.getReceiptId().equals(((ReceiptHeader)receipt.getHeader()).getReceiptId());
            }
        }
        return false;
    }

    @Override
    public void interceptMessage(StampyMessage<?> message, HostPort hostPort) throws InterceptException {
        switch (message.getMessageType()) {
            case DISCONNECT: {
                this.setReceiptId((DisconnectMessage)message);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void messageReceived(StampyMessage<?> message, HostPort hostPort) throws Exception {
        switch (message.getMessageType()) {
            case RECEIPT: {
                this.setReceiptId((String)null);
                if (!this.isCloseOnDisconnectMessage()) break;
                log.info("Receipt for disconnect message received, disconnecting");
                ((AbstractStampyMessageGateway)this.getGateway()).closeConnection(hostPort);
                throw new MessageListenerHaltException();
            }
            default: {
                return;
            }
        }
    }

    private void setReceiptId(DisconnectMessage message) {
        String id = ((DisconnectHeader)message.getHeader()).getReceipt();
        log.info("Disconnect message intercepted, receipt id {}", (Object)id);
        this.setReceiptId(id);
    }

    public boolean isCloseOnDisconnectMessage() {
        return this.closeOnDisconnectMessage;
    }

    public void setCloseOnDisconnectMessage(boolean closeOnDisconnectMessage) {
        this.closeOnDisconnectMessage = closeOnDisconnectMessage;
    }

    public String getReceiptId() {
        return this.receiptId;
    }

    public void setReceiptId(String receiptId) {
        this.receiptId = receiptId;
    }
}

