/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.client.listener.connected;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.StampyMessageListener;
import asia.stampy.common.heartbeat.StampyHeartbeatContainer;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.message.StompMessageType;
import asia.stampy.server.message.connected.ConnectedHeader;
import asia.stampy.server.message.connected.ConnectedMessage;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-client-server")
public abstract class AbstractConnectedMessageListener<CLNT extends AbstractStampyMessageGateway>
implements StampyMessageListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static StompMessageType[] TYPES = new StompMessageType[]{StompMessageType.CONNECTED};
    private StampyHeartbeatContainer heartbeatContainer;
    private CLNT gateway;

    @Override
    public StompMessageType[] getMessageTypes() {
        return TYPES;
    }

    @Override
    public boolean isForMessage(StampyMessage<?> message) {
        return true;
    }

    @Override
    public void messageReceived(StampyMessage<?> message, HostPort hostPort) throws Exception {
        log.debug("Received connect message {} from {}", message, (Object)hostPort);
        ConnectedMessage cm = (ConnectedMessage)message;
        int requested = ((ConnectedHeader)cm.getHeader()).getIncomingHeartbeat();
        if (requested <= 0 || ((AbstractStampyMessageGateway)this.gateway).getHeartbeat() <= 0) {
            return;
        }
        int heartbeat = Math.max(requested, ((AbstractStampyMessageGateway)this.gateway).getHeartbeat());
        log.info("Starting heartbeats for {} at {} ms intervals", (Object)hostPort, (Object)heartbeat);
        this.getHeartbeatContainer().start(hostPort, (AbstractStampyMessageGateway)this.getGateway(), heartbeat);
    }

    public StampyHeartbeatContainer getHeartbeatContainer() {
        return this.heartbeatContainer;
    }

    public void setHeartbeatContainer(StampyHeartbeatContainer heartbeatContainer) {
        this.heartbeatContainer = heartbeatContainer;
    }

    public CLNT getGateway() {
        return this.gateway;
    }

    public void setGateway(CLNT gateway) {
        this.gateway = gateway;
    }
}

